ORCA/M Asm65816 2.1.0

0001 4765
0002 4765              *************************************************************************************
0003 4765              *
0004 4765              *                   Line Edit v2.3
0005 4765              *
0006 4765              *       Copyright Apple Computer, Inc. 1986-1992
0007 4765              *                 All Rights Reserved
0008 4765              *
0009 4765              *                Written by Cheryl Ewy
0010 4765              *
0011 4765              *
0012 4765              *
0013 4765              * March 88          Harry Yee
0014 4765              *
0015 4765              * Converted to MAX
0016 4765              *
0017 4765              * March 23 88       Steven Glass
0018 4765              *
0019 4765              * Changed JMPs to end call routines to JMLs so same code can work in ROM.
0020 4765              *
0021 4765              * May 5, 1988 v2.1d2   Dan O. & Harry Y
0022 4765              *
0023 4765              * Call LETextBox2, TERec handle was not being locked when the ptr to it was being
0024 4765              * used. Problem arose memory got compacted and this ptr moved. The handle is now
0025 4765              * being locked.
0026 4765              *
0027 4765              * June 15, 1988        Harry Yee
0028 4765              *
0029 4765              * Took prototype bit out of LEVerNum for final release on System Disk 3.2.
0030 4765              *
0031 4765              * 15 Jun 88         Steven Glass
0032 4765              *
0033 4765              * LECopy did not check for the case where there was no selection. This led to
0034 4765              * memory trashing.
0035 4765              *
0036 4765              * 11 Jul 88         Steven Glass
0037 4765              *
0038 4765              * LETextBox2 now saves and restores all the text in the grafPort.
0039 4765              *
0040 4765              *
0041 4765              * 05 Aug 88         Steven Glass
0042 4765              *
0043 4765              * LETextBox2 could leave a handle un-disposed if the bounding box was not valid.
0044 4765              *
0045 4765              * In addition, LETextBox2 did not return a valid error code (when it worked or
0046 4765              * when it did not).
0047 4765              *
0048 4765              * 12 Oct 88         Steven Glass
0049 4765              *
0050 4765              * Added entry: GetLEDefPRoc to call table.  Added defproc to link process.
0051 4765              *
0052 4765              * 15 Feb 89         Harry Yee
0053 4765              *
0054 4765              * Extracted all the equates and put in separate file.  This file, LineEditEquates.asm,
0055 4765              * is now "included".
0056 4765              *
0057 4765              * 4/9/89            glass & mensch
0058 4765              *
0059 4765              * Added loop in tripleclick section of LEClick that removes the mouseUp event from the
0060 4765              * event queue.
0061 4765              *
0062 4765              * 15 May 89         Steven Glass
0063 4765              *
0064 4765              * Made the defproc a dynamic segment that is loaded  automatically when the GetLEProc
0065 4765              * address call is made. Added entry point FakeGetLEDefProc to do this.
0066 4765              *
0067 4765              * Changed version number to 8301.
0068 4765              *
0069 4765              * 12 Jun 89         Steven Glass
0070 4765              *
0071 4765              * Minor Change to LENew.
0072 4765              *
0073 4765              *************************************************************************************
0074 4765
0075 4765                       print nogen 
0076 4765                       print push,off 
0077 4765
0078 4765                       include 'All.Macros' 
0079 4765                       include 'e16.quickdraw' 
0080 4765                       include 'e16.event'            ;20-Mar-92 DAL
0081 4765
0082 4765                       print pop 
0083 4765
0084 4765                       include 'LineEditEquates.asm' 
0085 4765
0086 4765              ;-----------------------------------------------
0087 4765              ;
0088 4765              ;           Forward address and entries
0089 4765              ;
0090 4765              ;-----------------------------------------------
0091 4765
0092 4765                       ENTRY LEGetTextLen
0093 4765                       ENTRY LEGetTextHand
0094 4765                       ENTRY LESetJust
0095 4765                       ENTRY LETextBox2
0096 4765                       ENTRY LESetCaret
0097 4765                       ENTRY LESetHilite
0098 4765                       ENTRY LESetScrapLen
0099 4765                       ENTRY LEGetScrapLen
0100 4765                       ENTRY LEScrapHandle
0101 4765                       ENTRY LEToScrap
0102 4765                       ENTRY LEFromScrap
0103 4765                       ENTRY LETextBox
0104 4765                       ENTRY LEUpdate
0105 4765                       ENTRY LEInsert
0106 4765                       ENTRY LEDelete
0107 4765                       ENTRY LEPaste
0108 4765                       ENTRY LECopy
0109 4765                       ENTRY LECut
0110 4765                       ENTRY LEKey
0111 4765                       ENTRY LEDeactivate
0112 4765                       ENTRY LEActivate
0113 4765                       ENTRY LESetSelect
0114 4765                       ENTRY LEClick
0115 4765                       ENTRY LEIdle
0116 4765                       ENTRY LESetText
0117 4765                       ENTRY LEDispose
0118 4765                       ENTRY LENew
0119 4765                       ENTRY oStdEnd0
0120 4765                       ENTRY LEActive
0121 4765                       ENTRY LEReset
0122 4765                       ENTRY LEVersion
0123 4765                       ENTRY LEShutDown
0124 4765                       ENTRY LEStartUp
0125 4765                       ENTRY LEBootInit
0126 4765                       ENTRY STDERR4
0127 4765                       ENTRY STDEND4
0128 4765                       ENTRY STDEND0
0129 4765                       ENTRY LOCKREC
0130 4765                       ENTRY UNLOCKREC
0131 4765                       ENTRY STDENTRY
0132 4765                       ENTRY STDEXIT
0133 4765                       ENTRY STDEND
0134 4765                       ENTRY DRAWCARET
0135 4765                       ENTRY FINDPOINT
0136 4765                       ENTRY FindPoint2               ;14-May-91 DAL
0137 4765                       ENTRY HIDECARET
0138 4765                       ENTRY HILITE
0139 4765                       ENTRY FINDWORD
0140 4765                       ENTRY SHOWCARET
0141 4765                       ENTRY HILITE2
0142 4765                       ENTRY CLEANUPSEL
0143 4765                       ENTRY CMPSEL
0144 4765                       ENTRY SELSORT
0145 4765                       ENTRY SAVESTARTPROC
0146 4765                       ENTRY DELETEGUTS
0147 4765                       ENTRY REDRAW
0148 4765                       ENTRY PASTEGUTS
0149 4765                       ENTRY CALCSELLEN
0150 4765                       ENTRY CALCSTARTPTR
0151 4765                       ENTRY LOCKSCRAP
0152 4765                       ENTRY UNLOCKSCRAP
0153 4765                       ENTRY INSERTGUTS
0154 4765                       ENTRY STDENTRY2
0155 4765                       ENTRY STDERR0
0156 4765                       ENTRY LOCKLINE2
0157 4765                       ENTRY UNLOCKLINE
0158 4765                       ENTRY GETSELRECT
0159 4765                       ENTRY INVERTHOOK
0160 4765                       ENTRY LOCKLINE
0161 4765                       ENTRY CEXIT
0162 4765                       ENTRY BEXIT
0163 4765                       ENTRY AEXIT
0164 4765                       ENTRY STDERR
0165 4765                       ENTRY HOOKCOMMON
0166 4765                       ENTRY MeasureThisText
0167 4765                       ENTRY DrawThisText
0168 4765
0169 4765              ;-----------------------------------------------
0170 4765              ;
0171 4765              ; Global Imports
0172 4765              ;
0173 4765              ;-----------------------------------------------
0174 4765
0175 4765                       IMPORT OENDCALL 
0176 4765                       IMPORT ERROUT 
0177 4765                       IMPORT ENDCALL 
0178 4765                       IMPORT OERROUT 
0179 4765
0180 4765              ****************************************************************
0181 4765              *
0182 4765              * LINE EDIT CALL TABLE
0183 4765              *
0184 4765              ****************************************************************
0185 4765
0186 4765                       Export LECallTable 
0187 4765              LECallTable PROC 
0188 4765                       import FakeGetLEDefProc 
0189 4765
0190 4765
0191 4765              TheStart  
0192 4765 25 00 00 00           DC L:(TheEnd-TheStart)/4       ;num calls + 1
0193 4769 F8 47 FC 00           DC L:LEBootInit-1
0194 476D FB 47 FC 00           DC L:LEStartUp-1
0195 4771 5D 48 FC 00           DC L:LEShutDown-1
0196 4775 8E 48 FC 00           DC L:LEVersion-1
0197 4779 96 48 FC 00           DC L:LEReset-1
0198 477D A8 48 FC 00           DC L:LEActive-1
0199 4781 65 57 FC 00           DC L:oStdEnd0-1
0200 4785 65 57 FC 00           DC L:oStdEnd0-1
0201 4789 AD 48 FC 00           DC L:LENew-1
0202 478D B2 49 FC 00           DC L:LEDispose-1
0203 4791 EE 49 FC 00           DC L:LESetText-1
0204 4795 2D 4A FC 00           DC L:LEIdle-1
0205 4799 96 4A FC 00           DC L:LEClick-1
0206 479D 08 4C FC 00           DC L:LESetSelect-1
0207 47A1 33 4C FC 00           DC L:LEActivate-1
0208 47A5 53 4C FC 00           DC L:LEDeactivate-1
0209 47A9 76 4C FC 00           DC L:LEKey-1
0210 47AD 67 4E FC 00           DC L:LECut-1
0211 47B1 94 4E FC 00           DC L:LECopy-1
0212 47B5 C8 4E FC 00           DC L:LEPaste-1
0213 47B9 F5 4E FC 00           DC L:LEDelete-1
0214 47BD 15 4F FC 00           DC L:LEInsert-1
0215 47C1 50 4F FC 00           DC L:LEUpdate-1
0216 47C5 6C 4F FC 00           DC L:LETextBox-1
0217 47C9 83 50 FC 00           DC L:LEFromScrap-1
0218 47CD E5 50 FC 00           DC L:LEToScrap-1
0219 47D1 13 51 FC 00           DC L:LEScrapHandle-1
0220 47D5 20 51 FC 00           DC L:LEGetScrapLen-1
0221 47D9 29 51 FC 00           DC L:LESetScrapLen-1
0222 47DD 3E 51 FC 00           DC L:LESetHilite-1
0223 47E1 46 51 FC 00           DC L:LESetCaret-1
0224 47E5 D9 58 FC 00           DC L:LETextBox2-1              ; $20 ** added 2-87 Matthew Denman **
0225 47E9 6B 51 FC 00           DC L:LESetJust-1               ; $21 ** added 3-6-87 CAE **
0226 47ED 89 51 FC 00           DC L:LEGetTextHand-1           ; $22 ** added 3-24-87 CAE **
0227 47F1 AB 51 FC 00           DC L:LEGetTextLen-1            ; $23 ** added 4-24-87 CAE **
0228 47F5 46 66 FC 00           DC L:FakeGetLEDefProc-1        ; $24 ** Added 12 Oct 88 SEG
0229 47F9              TheEnd    
0230 47F9
0231 47F9                       EndP 
0232 47F9
0233 47F9
0234 47F9              ;****************************************************************
0235 47F9              ;*
0236 47F9              ;* DATA DECLARATIONS
0237 47F9              ;*
0238 47F9              ;****************************************************************
0239 47F9              ;
0240 47F9              ;	EXPORT LEData
0241 47F9              ;LEData	PROC
0242 47F9              ;
0243 47F9              ;	EndP
0244 47F9
0245 47F9
0246 47F9              ****************************************************************
0247 47F9              *
0248 47F9              * LEBootInit
0249 47F9              *
0250 47F9              ****************************************************************
0251 47F9
0252 47F9                       Export LEBootInit 
0253 47F9              LEBootInit PROC 
0254 47F9 4C 66 57              jmp   oStdEnd0
0255 47FC                       EndP 
0256 47FC
0257 47FC
0258 47FC              ****************************************************************
0259 47FC              *
0260 47FC              * LEStartUp
0261 47FC              *
0262 47FC              ****************************************************************
0263 47FC
0264 47FC                       Export LEStartUp 
0265 47FC              LEStartUp PROC 
0266 47FC
0267 47FC C9 00 00              cmp   #0                       ;already initialized?
0268 47FF F0 0A                 beq   Doit                     ;no
0269 4801 A2 01 14              ldx   #InitErr                 ;yes - so return error
0270 4804 A0 04 00              ldy   #4                       ;param size
0271 4807 5C B4 FC FE           jml   oErrOut
0272 480B
0273 480B 0B           Doit     phd   
0274 480C A3 09                 lda   9,s                      ;get zero page address
0275 480E 5B                    tcd   
0276 480F
0277 480F A2 FE 00              ldx   #$FE
0278 4812 74 00        Loop     stz   <LEZBase,x               ;clear zero page
0279 4814 CA                    dex   
0280 4815 CA                    dex   
0281 4816 10 FA                 bpl   Loop
0282 4818
0283 4818 A3 0B                 lda   11,s                     ;get program ID
0284 481A 85 5C                 sta   <ProgID
0285 481C
0286 481C F4 00 00 F4           PushLong #0 
0287 4822 F4 00 00              PushWord #0                    ;hi word of size
0288 4825 F4 00 01              PushWord #MaxChars             ;lo word of size
0289 4828 D4 5C                 PushZWord <ProgID              ;program ID
0290 482A F4 04 00              PushWord #$0004                ;page aligned, unpurgeable
0291 482D F4 00 00 F4           PushLong #0 
0292 4833 A2 02 09 22           _NewHandle                     ;allocate space for scrap
0293 483A 90 06                 bcc   GotMem
0294 483C AA                    tax                            ;xfer error code to X
0295 483D 68                    pla                            ;pull result
0296 483E 68                    pla   
0297 483F 4C 82 57              jmp   StdErr4                  ;return the error
0298 4842
0299 4842 68           GotMem   pla   
0300 4843 85 2A                 sta   <ScrapHandle
0301 4845 68                    pla   
0302 4846 85 2C                 sta   <ScrapHandle+2
0303 4848
0304 4848 A3 09                 lda   9,s                      ;get zero page address
0305 484A F4 00 00              PushWord #0 
0306 484D F4 14 00              PushWord #LETSNum 
0307 4850 F4 00 00              PushWord #0 
0308 4853 48                    pha   
0309 4854 A2 01 0D 22           _SetWAP                        ;set work area pointer
0310 485B
0311 485B 4C 7B 57              jmp   StdEnd4
0312 485E                       EndP 
0313 485E
0314 485E
0315 485E
0316 485E              ****************************************************************
0317 485E              *
0318 485E              * LEShutDown
0319 485E              *
0320 485E              ****************************************************************
0321 485E
0322 485E                       Export LEShutDown 
0323 485E              LEShutDown PROC 
0324 485E
0325 485E 0B                    phd   
0326 485F 5B                    tcd   
0327 4860 D0 06                 bne   Doit
0328 4862 A2 03 14              ldx   #ActiveErr               ;return error if Line Edit not active
0329 4865 4C 74 57              jmp   StdErr0
0330 4868
0331 4868 D4 2C D4 2A  Doit     PushZLong <ScrapHandle 
0332 486C A2 02 10 22           _DisposeHandle                 ;release scrap space
0333 4873 90 04                 bcc   OK
0334 4875 AA                    tax                            ;xfer error code to X
0335 4876 4C 74 57              jmp   StdErr0                  ;return the error
0336 4879
0337 4879 F4 00 00     OK       PushWord #0 
0338 487C F4 14 00              PushWord #LETSNum 
0339 487F F4 00 00              PushWord #0 
0340 4882 F4 00 00              PushWord #0 
0341 4885 A2 01 0D 22           _SetWAP                        ;clear work area pointer
0342 488C
0343 488C 4C 6D 57              jmp   StdEnd0
0344 488F                       EndP 
0345 488F
0346 488F
0347 488F
0348 488F              ****************************************************************
0349 488F              *
0350 488F              * LEVersion
0351 488F              *
0352 488F              ****************************************************************
0353 488F
0354 488F                       Export LEVersion 
0355 488F              LEVersion PROC 
0356 488F A9 00 03              lda   #LEVerNum
0357 4892 83 07                 sta   7,s
0358 4894 4C 66 57              jmp   oStdEnd0
0359 4897                       EndP 
0360 4897
0361 4897
0362 4897              ****************************************************************
0363 4897              *
0364 4897              * LEReset
0365 4897              *
0366 4897              ****************************************************************
0367 4897
0368 4897                       Export LEReset 
0369 4897              LEReset  PROC 
0370 4897 C9 00 00              cmp   #0                       ;is LE active?
0371 489A F0 0A                 beq   Done                     ;no
0372 489C A2 02 14              ldx   #ResetErr                ;yes - so return error
0373 489F A0 00 00              ldy   #0                       ;param size
0374 48A2 5C B4 FC FE           jml   oErrOut
0375 48A6
0376 48A6 4C 66 57     Done     jmp   oStdEnd0
0377 48A9                       EndP 
0378 48A9
0379 48A9
0380 48A9              ****************************************************************
0381 48A9              *
0382 48A9              * LEActive
0383 48A9              *
0384 48A9              ****************************************************************
0385 48A9
0386 48A9                       Export LEActive 
0387 48A9              LEActive PROC 
0388 48A9 83 07                 sta   7,s
0389 48AB 4C 66 57              jmp   oStdEnd0
0390 48AE                       EndP 
0391 48AE
0392 48AE
0393 48AE              ****************************************************************
0394 48AE              *
0395 48AE              * LENew
0396 48AE              *
0397 48AE              *
0398 48AE              * Change History
0399 48AE              *
0400 48AE              * 12 Jun 89         Steven Glass
0401 48AE              *
0402 48AE              * Fixed bug introduced looking for PW char.  Trying to save
0403 48AE              * size in x I did a txa rather than a tax.
0404 48AE              *
0405 48AE              ****************************************************************
0406 48AE                       Export LENew 
0407 48AE              LENew    PROC                           ;LENew uses TempPtr1 and TempPtr2
0408 48AE 0B                    phd   
0409 48AF 5B                    tcd   
0410 48B0
0411 48B0 F4 00 00 F4           PushLong #0 
0412 48B6 F4 00 00              PushWord #0                    ;hi word of size
0413 48B9 F4 3A 00              PushWord #LERecSize            ;lo word of size
0414 48BC D4 5C                 PushZWord <ProgID              ;prog ID
0415 48BE F4 00 00              PushWord #0                    ;unpurgeable
0416 48C1 F4 00 00 F4           PushLong #0 
0417 48C7 A2 02 09 22           _NewHandle                     ;allocate mem for the edit record
0418 48CE 90 03                 bcc   GotMem
0419 48D0 AA                    tax                            ;xfer error code to X
0420 48D1 80 57                 bra   MemErr
0421 48D3
0422 48D3 68           GotMem   pla                            ;get handle to mem
0423 48D4 85 1A                 sta   <RecHandle               ;save it
0424 48D6 83 15                 sta   21,s                     ;and return it
0425 48D8 68                    pla   
0426 48D9 85 1C                 sta   <RecHandle+2
0427 48DB 83 15                 sta   21,s
0428 48DD 20 6C 58              jsr   LockRec
0429 48E0
0430 48E0 A9 00 00              lda   #0
0431 48E3 A0 3A 00              ldy   #LERecSize
0432 48E6 88                    dey   
0433 48E7 88                    dey   
0434 48E8 97 1E        ZLoop    sta   [<RecPtr],y              ;zero out record
0435 48EA 88                    dey   
0436 48EB 88                    dey   
0437 48EC 10 FA                 bpl   ZLoop
0438 48EE
0439 48EE A0 06 00              ldy   #leMaxLength
0440 48F1 A3 09                 lda   9,s                      ;get maxtextlen parameter
0441 48F3 29 FF 7F              and   #$7FFF
0442 48F6 C9 00 01              cmp   #MaxChars                ;make sure it's not too big
0443 48F9 90 03                 bcc   OK
0444 48FB A9 00 01              lda   #MaxChars
0445 48FE 97 1E        OK       sta   [<RecPtr],y
0446 4900 8A                    txa                            ; save in x for use below
0447 4901
0448 4901 A3 09                 lda   9,s                      ; use
0449 4903 29 00 80              and   #$8000
0450 4906 F0 08                 beq   NoPWChar
0451 4908
0452 4908 A9 2A 00              lda   #'*'
0453 490B A0 38 00              ldy   #lePWChar
0454 490E 97 1E                 sta   [<RecPtr],y
0455 4910              NoPWChar  
0456 4910
0457 4910 48                    pha                            ; space for result
0458 4911 48                    pha   
0459 4912 F4 00 00              PushWord #0                    ;hi word of size
0460 4915 DA                    phx                            ;lo word of size - maxtextlen parameter
0461 4916 D4 5C                 PushZWord <ProgID              ;program ID
0462 4918 F4 00 00              PushWord #0                    ;unpurgeable
0463 491B 48                    pha                            ; unused long
0464 491C 48                    pha   
0465 491D A2 02 09 22           _NewHandle                     ;allocate mem for the line
0466 4924 90 0D                 bcc   GotMem2
0467 4926 AA                    tax                            ;xfer error code to X
0468 4927 20 82 58              jsr   UnLockRec                ;clean up
0469 492A 68           MemErr   pla                            ;pull result
0470 492B 68                    pla   
0471 492C A0 0A 00              ldy   #10                      ;param size
0472 492F 5C B3 FC FE           jml   ErrOut                   ;return the error
0473 4933
0474 4933 68           GotMem2  pla   
0475 4934 87 1E                 sta   [<RecPtr]
0476 4936 A0 02 00              ldy   #2
0477 4939 68                    pla   
0478 493A 97 1E                 sta   [<RecPtr],y
0479 493C
0480 493C A3 0F                 lda   15,s                     ;get ptr to destrect parameter
0481 493E 85 04                 sta   <TempPtr1
0482 4940 A3 11                 lda   17,s
0483 4942 85 06                 sta   <TempPtr1+2
0484 4944 A9 08 00              lda   #leDestRect              ;create ptr to destrect field and
0485 4947 20 9B 49              jsr   CopyRect                 ;copy parameter into field
0486 494A
0487 494A A3 0B                 lda   11,s                     ;get ptr to viewrect parameter
0488 494C 85 04                 sta   <TempPtr1
0489 494E A3 0D                 lda   13,s
0490 4950 85 06                 sta   <TempPtr1+2
0491 4952 A9 10 00              lda   #leViewRect              ;create ptr to viewrect field and
0492 4955 20 9B 49              jsr   CopyRect                 ;copy parameter into field
0493 4958
0494 4958 F4 00 00 F4           PushLong #0 
0495 495E A2 04 1C 22           _GetPort                       ;get handle to current port
0496 4965 A0 18 00              ldy   #lePort
0497 4968 68                    pla   
0498 4969 97 1E                 sta   [<RecPtr],y              ;and store in port field
0499 496B C8                    iny   
0500 496C C8                    iny   
0501 496D 68                    pla   
0502 496E 97 1E                 sta   [<RecPtr],y
0503 4970
0504 4970 F4 00 00 7B           PushZPtr <TempPtr1             ;push address of TempPtr1
0505 4979 A2 04 96 22           _GetFontInfo                   ;returns 4 words of info
0506 4980 18                    clc   
0507 4981 A5 04                 lda   <TempPtr1                ;get ascent
0508 4983 65 0A                 adc   <TempPtr2+2              ;add in leading
0509 4985 A0 1E 00              ldy   #leBaseHite
0510 4988 97 1E                 sta   [<RecPtr],y              ;store in basehite field
0511 498A 65 06                 adc   <TempPtr1+2              ;add in descent
0512 498C A0 1C 00              ldy   #leLineHite
0513 498F 97 1E                 sta   [<RecPtr],y              ;store in linehite field
0514 4991
0515 4991 20 82 58              jsr   UnLockRec
0516 4994 A0 0A 00              ldy   #10                      ;param size
0517 4997 5C B0 FC FE           jml   EndCall
0518 499B
0519 499B              ;-------------------------------------------------------------------------------
0520 499B
0521 499B 18           CopyRect clc   
0522 499C 65 1E                 adc   <RecPtr                  ;create ptr to field
0523 499E 85 08                 sta   <TempPtr2
0524 49A0 A5 20                 lda   <RecPtr+2
0525 49A2 69 00 00              adc   #0
0526 49A5 85 0A                 sta   <TempPtr2+2
0527 49A7 A0 06 00              ldy   #6
0528 49AA B7 04        RLoop    lda   [<TempPtr1],y            ;copy parameter into field
0529 49AC 97 08                 sta   [<TempPtr2],y
0530 49AE 88                    dey   
0531 49AF 88                    dey   
0532 49B0 10 F8                 bpl   RLoop
0533 49B2 60                    rts   
0534 49B3
0535 49B3                       EndP 
0536 49B3
0537 49B3
0538 49B3              ****************************************************************
0539 49B3              *
0540 49B3              * LEDispose
0541 49B3              *
0542 49B3              ****************************************************************
0543 49B3
0544 49B3                       Export LEDispose 
0545 49B3              LEDispose PROC 
0546 49B3
0547 49B3 0B                    phd   
0548 49B4 5B                    tcd   
0549 49B5
0550 49B5 A3 09                 lda   9,s
0551 49B7 85 1A                 sta   <RecHandle
0552 49B9 A3 0B                 lda   11,s
0553 49BB 85 1C                 sta   <RecHandle+2
0554 49BD 20 6C 58              jsr   LockRec
0555 49C0
0556 49C0 A0 02 00              ldy   #2
0557 49C3 B7 1E                 lda   [<RecPtr],y              ;push handle to line
0558 49C5 48                    pha   
0559 49C6 A7 1E                 lda   [<RecPtr]
0560 49C8 48                    pha   
0561 49C9 20 82 58              jsr   UnLockRec
0562 49CC
0563 49CC A2 02 10 22           _DisposeHandle                 ;dispose of line
0564 49D3 90 04                 bcc   OK
0565 49D5 AA                    tax                            ;xfer error code to X
0566 49D6 4C 82 57              jmp   StdErr4                  ;return the error
0567 49D9
0568 49D9 A3 0B        OK       lda   11,s                     ;push handle to edit record
0569 49DB 48                    pha   
0570 49DC A3 0B                 lda   11,s
0571 49DE 48                    pha   
0572 49DF A2 02 10 22           _DisposeHandle                 ;dispose of edit record
0573 49E6 90 04                 bcc   Done
0574 49E8 AA                    tax                            ;xfer error code to X
0575 49E9 4C 82 57              jmp   StdErr4                  ;return the error
0576 49EC
0577 49EC 4C 7B 57     Done     jmp   StdEnd4
0578 49EF
0579 49EF                       EndP 
0580 49EF
0581 49EF
0582 49EF              ****************************************************************
0583 49EF              *
0584 49EF              * LESetText
0585 49EF              *
0586 49EF              ****************************************************************
0587 49EF
0588 49EF                       Export LESetText 
0589 49EF              LESetText PROC 
0590 49EF
0591 49EF 0B                    phd   
0592 49F0 5B                    tcd   
0593 49F1
0594 49F1 A2 0A 00              ldx   #10
0595 49F4 20 89 57              jsr   StdEntry
0596 49F7
0597 49F7              ;	ldy	#leHScrollPos
0598 49F7              ;	lda	#0
0599 49F7              ;	sta	[<RecPtr],y
0600 49F7
0601 49F7 A3 0D                 lda   13,s                     ;text length
0602 49F9 A0 06 00              ldy   #leMaxLength
0603 49FC D7 1E                 cmp   [<RecPtr],y              ;is length < max line length?
0604 49FE 90 02                 bcc   OK                       ;yes
0605 4A00 B7 1E                 lda   [<RecPtr],y              ;no - so set length to max line length
0606 4A02 A0 04 00     OK       ldy   #leLength
0607 4A05 97 1E                 sta   [<RecPtr],y
0608 4A07 A0 20 00              ldy   #leSelStart              ;set insertion point to end of text
0609 4A0A 97 1E                 sta   [<RecPtr],y
0610 4A0C A0 22 00              ldy   #leSelEnd
0611 4A0F 97 1E                 sta   [<RecPtr],y
0612 4A11
0613 4A11 A8                    tay                            ;transfer text length to Y
0614 4A12 F0 14                 beq   Done                     ;quit if length is 0
0615 4A14 88                    dey   
0616 4A15
0617 4A15 A3 0F        Cont     lda   15,s                     ;get ptr to text
0618 4A17 85 14                 sta   <TextPtr
0619 4A19 A3 11                 lda   17,s
0620 4A1B 85 16                 sta   <TextPtr+2
0621 4A1D
0622 4A1D              ;----------------------------------------------------
0623 4A1D              ;
0624 4A1D              ; Switch to mixed mode (8 bit m) to move the
0625 4A1D              ; characters to handle.
0626 4A1D              ;
0627 4A1D              ;----------------------------------------------------
0628 4A1D E2 20                 sep   #%00100000
0629 4A1F                       longa off
0630 4A1F B7 14        Loop     lda   [<TextPtr],y             ;copy text into line
0631 4A21 97 26                 sta   [<LinePtr],y
0632 4A23 88                    dey   
0633 4A24 10 F9                 bpl   Loop
0634 4A26 C2 20                 rep   #%00100000
0635 4A28                       longa on
0636 4A28
0637 4A28 20 2C 58     Done     jsr   StdExit
0638 4A2B 4C 5A 57              jmp   StdEnd
0639 4A2E                       EndP 
0640 4A2E
0641 4A2E
0642 4A2E
0643 4A2E              ****************************************************************
0644 4A2E              *
0645 4A2E              * LEIdle
0646 4A2E              *
0647 4A2E              ****************************************************************
0648 4A2E
0649 4A2E                       Export LEIdle 
0650 4A2E              LEIdle   PROC 
0651 4A2E
0652 4A2E 0B                    phd   
0653 4A2F 5B                    tcd   
0654 4A30
0655 4A30 A2 04 00              ldx   #4
0656 4A33 20 89 57              jsr   StdEntry
0657 4A36
0658 4A36 A0 26 00              ldy   #leCarAct
0659 4A39 B7 1E                 lda   [<RecPtr],y
0660 4A3B F0 54                 beq   Done                     ;quit if not active
0661 4A3D
0662 4A3D AF DE 00 E1           lda   >TickCnt+2
0663 4A41 A0 2C 00              ldy   #leCarTime+2
0664 4A44 D7 1E                 cmp   [<RecPtr],y
0665 4A46 90 49                 bcc   Done                     ;quit if hi word of tickcnt < cartime
0666 4A48 D0 0B                 bne   Time                     ;branch if tickcnt > cartime
0667 4A4A AF DC 00 E1           lda   >TickCnt                 ;if hi words equal then check lo words
0668 4A4E A0 2A 00              ldy   #leCarTime
0669 4A51 D7 1E                 cmp   [<RecPtr],y
0670 4A53 90 3C                 bcc   Done                     ;quit if lo word of tickcnt < cartime
0671 4A55
0672 4A55 F4 00 00 F4  Time     PushLong #0 
0673 4A5B A2 06 12 22           _GetCaretTime                  ;get # ticks until next blink
0674 4A62 A2 00 00              ldx   #0                       ;init 'no flash flag' to 0
0675 4A65 68                    pla   
0676 4A66 D0 04                 bne   Flash
0677 4A68 A9 3C 00              lda   #60                      ;caret is set to 'no flash' so inc
0678 4A6B E8                    inx                            ;CarTime so don't call _GetCaretTime so
0679 4A6C              ;                                       ;often and set 'no flash flag'
0680 4A6C A0 2A 00     Flash    ldy   #leCarTime
0681 4A6F 18                    clc                            ;add '# ticks until next blink' to
0682 4A70 6F DC 00 E1           adc   >TickCnt                 ;current tick count
0683 4A74 97 1E                 sta   [<RecPtr],y              ;and save
0684 4A76 C8                    iny   
0685 4A77 C8                    iny   
0686 4A78 68                    pla   
0687 4A79 6F DE 00 E1           adc   >TickCnt+2
0688 4A7D 97 1E                 sta   [<RecPtr],y
0689 4A7F
0690 4A7F E0 00 00              cpx   #0                       ;check 'no flash flag'
0691 4A82 D0 0D                 bne   Done                     ;quit if it's set
0692 4A84
0693 4A84 20 C1 54              jsr   DrawCaret                ;flip the caret
0694 4A87
0695 4A87 A0 28 00              ldy   #leCarOn
0696 4A8A A9 01 00              lda   #1
0697 4A8D 57 1E                 eor   [<RecPtr],y
0698 4A8F 97 1E                 sta   [<RecPtr],y              ;flip the flag
0699 4A91
0700 4A91 20 2C 58     Done     jsr   StdExit
0701 4A94 4C 5A 57              jmp   StdEnd
0702 4A97
0703 4A97                       EndP 
0704 4A97
0705 4A97
0706 4A97              ****************************************************************
0707 4A97              *
0708 4A97              * LEClick
0709 4A97              *
0710 4A97              ****************************************************************
0711 4A97
0712 4A97                       Export LEClick 
0713 4A97              LEClick  PROC 
0714 4A97
0715 4A97              EventPtr equ TempPtr1 
0716 4A97              SaveStart equ TempPtr2 
0717 4A97              SaveEnd  equ TempPtr2+2 
0718 4A97
0719 4A97 0B                    phd   
0720 4A98 5B                    tcd   
0721 4A99
0722 4A99 A2 08 00              ldx   #8
0723 4A9C 20 89 57              jsr   StdEntry
0724 4A9F 64 52                 stz   <RevFlag                 ;clear reversed flag
0725 4AA1
0726 4AA1 A3 0D                 lda   13,s                     ;get Event Record pointer
0727 4AA3 85 04                 sta   <EventPtr
0728 4AA5 A3 0F                 lda   15,s
0729 4AA7 85 06                 sta   <EventPtr+2
0730 4AA9 A0 02 00              ldy   #2
0731 4AAC B7 04                 lda   [<EventPtr],y            ;get button number and save
0732 4AAE 85 5A                 sta   <BNum
0733 4AB0 A0 0A 00              ldy   #10
0734 4AB3 B7 04                 lda   [<EventPtr],y            ;get mouse loc
0735 4AB5 85 3C                 sta   <SelPoint
0736 4AB7 C8                    iny   
0737 4AB8 C8                    iny   
0738 4AB9 B7 04                 lda   [<EventPtr],y
0739 4ABB 85 3E                 sta   <SelPoint+2
0740 4ABD F4 00 00 7B           PushZPtr <SelPoint 
0741 4AC6 A2 04 85 22           _GlobalToLocal                 ;and convert to local coordinates
0742 4ACD
0743 4ACD 20 36 53              jsr   FindPoint                ;returns char index in SelPoint
0744 4AD0 90 03                 bcc   GotIndex
0745 4AD2 4C 91 4B              jmp   Done                     ;point not in viewrect so quit
0746 4AD5
0747 4AD5 20 A2 54     GotIndex jsr   HideCaret
0748 4AD8 20 D6 54              jsr   HiLite                   ;remove selection
0749 4ADB
0750 4ADB A5 3C                 lda   <SelPoint                ;get current click loc
0751 4ADD C5 48                 cmp   <ClickLoc                ;same loc as previous click?
0752 4ADF D0 6B                 bne   Single                   ;no - so not a double click
0753 4AE1
0754 4AE1              ;-------------------------------------------------------------------------------
0755 4AE1              ; Double Click Stuff
0756 4AE1
0757 4AE1 F4 00 00 F4           PushLong #0 
0758 4AE7 A2 06 11 22           _GetDblTime                    ;get current double click setting
0759 4AEE 68                    pla   
0760 4AEF 0A                    asl   a                        ;mult by 2 and save
0761 4AF0 85 4E                 sta   <DoubleTime
0762 4AF2 68                    pla                            ;discard hi word
0763 4AF3
0764 4AF3 38                    sec   
0765 4AF4 A0 06 00              ldy   #6
0766 4AF7 B7 04                 lda   [<EventPtr],y            ;get lo word of click time
0767 4AF9 E5 4A                 sbc   <ClickTime               ;subtract previous click time
0768 4AFB AA                    tax                            ;store in X
0769 4AFC C8                    iny   
0770 4AFD C8                    iny   
0771 4AFE B7 04                 lda   [<EventPtr],y            ;get hi word of click time
0772 4B00 E5 4C                 sbc   <ClickTime+2             ;subtract previous click time
0773 4B02 D0 48                 bne   Single                   ;if not 0 then too long between clicks
0774 4B04 E4 4E                 cpx   <DoubleTime              ;less than double click setting?
0775 4B06 B0 44                 bcs   Single                   ;no
0776 4B08 A5 50                 lda   <DoubleClick             ;already had double-click?
0777 4B0A D0 16                 bne   Triple                   ;yes - so now have triple click
0778 4B0C E6 50                 inc   <DoubleClick             ;no - so set double click flag
0779 4B0E
0780 4B0E A5 3C                 lda   <SelPoint
0781 4B10 20 32 54              jsr   FindWord                 ;find word containing selpoint
0782 4B13 A5 38                 lda   <WordStart
0783 4B15 85 08                 sta   <SaveStart               ;save wordstart
0784 4B17 A0 20 00              ldy   #leSelStart
0785 4B1A 97 1E                 sta   [<RecPtr],y              ;set new selstart
0786 4B1C A5 3A                 lda   <WordEnd
0787 4B1E 85 0A                 sta   <SaveEnd                 ;save wordend
0788 4B20 80 41                 bra   StoreEnd                 ;set new selend
0789 4B22
0790 4B22              ;-------------------------------------------------------------------------------
0791 4B22              ; Triple Click Stuff
0792 4B22
0793 4B22 A9 00 00     Triple   lda   #0                       ;set selection range to whole line
0794 4B25 A0 20 00              ldy   #leSelStart
0795 4B28 97 1E                 sta   [<RecPtr],y
0796 4B2A A0 04 00              ldy   #leLength
0797 4B2D B7 1E                 lda   [<RecPtr],y
0798 4B2F A0 22 00              ldy   #leSelEnd
0799 4B32 97 1E                 sta   [<RecPtr],y
0800 4B34 20 7E 54              jsr   ShowCaret                ;** bug fix 2-19-87 CAE **
0801 4B37 20 D6 54              jsr   HiLite                   ;show new selection
0802 4B3A              ;
0803 4B3A              ; 4/8/89            mensch
0804 4B3A              ; inserted the following loop to troll the event queue for the mouseup that should be
0805 4B3A              ; hanging around on the stack
0806 4B3A              @Wait     
0807 4B3A F4 00 00              PushWord #0 
0808 4B3D D4 5A                 PushZWord <BNum                ;button number
0809 4B3F A2 06 0F 22           _WaitMouseUp 
0810 4B46 68                    pla                            ;is button still down?
0811 4B47 D0 F1                 bne   @wait                    ;yes
0812 4B49              ; END
0813 4B49 4C 91 4B              jmp   Done
0814 4B4C
0815 4B4C              ;-------------------------------------------------------------------------------
0816 4B4C              ; Single Click Stuff
0817 4B4C
0818 4B4C 64 50        Single   stz   <DoubleClick             ;clear double click flag
0819 4B4E A0 0E 00              ldy   #14
0820 4B51 B7 04                 lda   [<EventPtr],y            ;get modifiers
0821 4B53 29 00 02              and   #$0200                   ;shift key pressed?
0822 4B56 D0 09                 bne   Extend                   ;yes - so extend selection
0823 4B58 A5 3C                 lda   <SelPoint                ;no - so set insertion point to new loc
0824 4B5A A0 20 00              ldy   #leSelStart
0825 4B5D 97 1E                 sta   [<RecPtr],y              ;set new selstart
0826 4B5F 80 02                 bra   StoreEnd
0827 4B61
0828 4B61 A5 3C        Extend   lda   <SelPoint                ;extend selection to new loc
0829 4B63
0830 4B63              ;-------------------------------------------------------------------------------
0831 4B63              ; Save click info and show new insertion point or selection range
0832 4B63
0833 4B63 A0 22 00     StoreEnd ldy   #leSelEnd
0834 4B66 97 1E                 sta   [<RecPtr],y              ;set new selend
0835 4B68
0836 4B68 A5 3C                 lda   <SelPoint
0837 4B6A 85 48                 sta   <ClickLoc                ;save current click loc
0838 4B6C A0 06 00              ldy   #6
0839 4B6F B7 04                 lda   [<EventPtr],y            ;get lo word of click time
0840 4B71 85 4A                 sta   <ClickTime               ;and save
0841 4B73 C8                    iny   
0842 4B74 C8                    iny   
0843 4B75 B7 04                 lda   [<EventPtr],y            ;get hi word of click time
0844 4B77 85 4C                 sta   <ClickTime+2             ;and save
0845 4B79
0846 4B79 20 7E 54              jsr   ShowCaret
0847 4B7C 20 D6 54              jsr   HiLite                   ;show selection
0848 4B7F
0849 4B7F              ;-------------------------------------------------------------------------------
0850 4B7F              ; Check if button still down
0851 4B7F
0852 4B7F F4 00 00     Wait     PushWord #0 
0853 4B82 D4 5A                 PushZWord <BNum                ;button number
0854 4B84 A2 06 0F 22           _WaitMouseUp 
0855 4B8B 68                    pla                            ;is button still down?
0856 4B8C D0 09                 bne   BtnDown                  ;yes
0857 4B8E 20 7E 54              jsr   ShowCaret                ;no - so done
0858 4B91 20 2C 58     Done     jsr   StdExit
0859 4B94 4C 5A 57              jmp   StdEnd
0860 4B97
0861 4B97              ;-------------------------------------------------------------------------------
0862 4B97              ; Drag Stuff
0863 4B97
0864 4B97 F4 00 00 7B  BtnDown  PushZPtr <SelPoint             ;push ptr to space for result
0865 4BA0 A2 06 0C 22           _GetMouse                      ;get current mouse position
0866 4BA7 20 36 53              jsr   FindPoint                ;convert to char index
0867 4BAA B0 D3                 bcs   Wait                     ;point not in viewrect
0868 4BAC
0869 4BAC A5 3C                 lda   <SelPoint
0870 4BAE A0 22 00              ldy   #leSelEnd
0871 4BB1 D7 1E                 cmp   [<RecPtr],y              ;has mouse moved?
0872 4BB3 F0 CA                 beq   Wait                     ;no
0873 4BB5
0874 4BB5 A5 50                 lda   <DoubleClick             ;was this a double click?
0875 4BB7 F0 29                 beq   DoHilite                 ;no - so skip some of this stuff
0876 4BB9
0877 4BB9 A5 3C                 lda   <SelPoint
0878 4BBB 20 32 54              jsr   FindWord                 ;find word containing new mouse loc
0879 4BBE A5 3C                 lda   <SelPoint
0880 4BC0 C5 08                 cmp   <SaveStart               ;is selpoint to left of savestart?
0881 4BC2 90 0F                 bcc   OnLeft                   ;yes
0882 4BC4
0883 4BC4 A5 52        OnRight  lda   <RevFlag                 ;is drag direction reversed?
0884 4BC6 F0 07                 beq   GoRight                  ;no - so OK
0885 4BC8 A5 08                 lda   <SaveStart               ;yes - so set selstart to savestart
0886 4BCA 20 F8 4B              jsr   Reverse                  ;and reverse direction of drag
0887 4BCD 64 52                 stz   <RevFlag                 ;clear reversed flag
0888 4BCF A5 3A        GoRight  lda   <WordEnd                 ;expand to the right
0889 4BD1 80 0D                 bra   NewPoint
0890 4BD3
0891 4BD3 A5 52        OnLeft   lda   <RevFlag                 ;is drag direction reversed?
0892 4BD5 D0 07                 bne   GoLeft                   ;yes - so OK
0893 4BD7 A5 0A                 lda   <SaveEnd                 ;no - so set selstart to saveend
0894 4BD9 20 F8 4B              jsr   Reverse                  ;and reverse direction of drag
0895 4BDC E6 52                 inc   <RevFlag                 ;set reversed flag
0896 4BDE A5 38        GoLeft   lda   <WordStart               ;expand to the left
0897 4BE0
0898 4BE0 85 3C        NewPoint sta   <SelPoint
0899 4BE2
0900 4BE2 20 A2 54     DoHilite jsr   HideCaret
0901 4BE5 A0 22 00              ldy   #leSelEnd
0902 4BE8 B7 1E                 lda   [<RecPtr],y
0903 4BEA 85 34                 sta   <DispStart               ;dispstart = previous selend
0904 4BEC A5 3C                 lda   <SelPoint
0905 4BEE 85 36                 sta   <DispEnd                 ;dispend = new selend
0906 4BF0 97 1E                 sta   [<RecPtr],y              ;set new selend
0907 4BF2 20 EC 54              jsr   HiLite2                  ;invert the changed part
0908 4BF5 4C 7F 4B              jmp   Wait                     ;too far for BRA
0909 4BF8
0910 4BF8              ;-------------------------------------------------------------------------------
0911 4BF8
0912 4BF8 A0 20 00     Reverse  ldy   #leSelStart
0913 4BFB 97 1E                 sta   [<RecPtr],y              ;set selstart to new value
0914 4BFD A5 08                 lda   <SaveStart               ;invert word the double click was on
0915 4BFF 85 34                 sta   <DispStart               ;so that when we change directions it
0916 4C01 A5 0A                 lda   <SaveEnd                 ;stays highlighted
0917 4C03 85 36                 sta   <DispEnd
0918 4C05 20 EC 54              jsr   HiLite2
0919 4C08 60                    rts   
0920 4C09
0921 4C09                       EndP 
0922 4C09
0923 4C09
0924 4C09              ****************************************************************
0925 4C09              *
0926 4C09              * LESetSelect
0927 4C09              *
0928 4C09              ****************************************************************
0929 4C09
0930 4C09                       Export LESetSelect 
0931 4C09              LESetSelect PROC 
0932 4C09
0933 4C09 0B                    phd   
0934 4C0A 5B                    tcd   
0935 4C0B
0936 4C0B A2 08 00              ldx   #8
0937 4C0E 20 89 57              jsr   StdEntry
0938 4C11
0939 4C11 20 A2 54              jsr   HideCaret
0940 4C14 20 D6 54              jsr   HiLite                   ;remove old selection
0941 4C17
0942 4C17              ; The un-scroll code was here, but now it's down below (22-Jan-92 DAL)
0943 4C17
0944 4C17 A3 0F                 lda   15,s                     ;get new selstart
0945 4C19 A0 20 00              ldy   #leSelStart
0946 4C1C 97 1E                 sta   [<RecPtr],y              ;set new selstart
0947 4C1E
0948 4C1E A3 0D                 lda   13,s                     ;get new selend
0949 4C20 A0 22 00              ldy   #leSelEnd
0950 4C23 97 1E                 sta   [<RecPtr],y              ;set new selend
0951 4C25
0952 4C25 20 40 57              jsr   CleanUpSel               ;clean up selection
0953 4C28
0954 4C28 20 7E 54              jsr   ShowCaret
0955 4C2B 20 D6 54              jsr   HiLite                   ;show new selection
0956 4C2E
0957 4C2E 20 2C 58              jsr   StdExit
0958 4C31 4C 5A 57              jmp   StdEnd
0959 4C34
0960 4C34                       EndP 
0961 4C34
0962 4C34
0963 4C34              ****************************************************************
0964 4C34              *
0965 4C34              * LEActivate
0966 4C34              *
0967 4C34              ****************************************************************
0968 4C34
0969 4C34                       Export LEActivate 
0970 4C34              LEActivate PROC 
0971 4C34
0972 4C34 0B                    phd   
0973 4C35 5B                    tcd   
0974 4C36
0975 4C36 A2 04 00              ldx   #4
0976 4C39 20 89 57              jsr   StdEntry
0977 4C3C
0978 4C3C A0 24 00              ldy   #leActFlg
0979 4C3F B7 1E                 lda   [<RecPtr],y              ;already active?
0980 4C41 D0 0B                 bne   Done                     ;yes - so done
0981 4C43 A9 01 00              lda   #1                       ;no - so set active flag to true
0982 4C46 97 1E                 sta   [<RecPtr],y
0983 4C48
0984 4C48 20 7E 54              jsr   ShowCaret                ;show the caret
0985 4C4B 20 D6 54              jsr   HiLite                   ;show selection
0986 4C4E
0987 4C4E 20 2C 58     Done     jsr   StdExit
0988 4C51 4C 5A 57              jmp   StdEnd
0989 4C54
0990 4C54                       EndP 
0991 4C54
0992 4C54
0993 4C54              ****************************************************************
0994 4C54              *
0995 4C54              * LEDeactivate
0996 4C54              *
0997 4C54              ****************************************************************
0998 4C54
0999 4C54                       Export LEDeactivate 
1000 4C54              LEDeactivate PROC 
1001 4C54
1002 4C54 0B                    phd   
1003 4C55 5B                    tcd   
1004 4C56
1005 4C56 A2 04 00              ldx   #4
1006 4C59 20 89 57              jsr   StdEntry
1007 4C5C
1008 4C5C A0 24 00              ldy   #leActFlg
1009 4C5F B7 1E                 lda   [<RecPtr],y              ;already inactive?
1010 4C61 F0 0E                 beq   Done                     ;yes - so done
1011 4C63
1012 4C63 20 A2 54              jsr   HideCaret                ;hide the caret
1013 4C66 20 D6 54              jsr   HiLite                   ;remove the selection
1014 4C69
1015 4C69 A0 24 00              ldy   #leActFlg
1016 4C6C A9 00 00              lda   #0                       ;set active flag to false
1017 4C6F 97 1E                 sta   [<RecPtr],y
1018 4C71
1019 4C71 20 2C 58     Done     jsr   StdExit
1020 4C74 4C 5A 57              jmp   StdEnd
1021 4C77
1022 4C77                       EndP 
1023 4C77
1024 4C77
1025 4C77              ****************************************************************
1026 4C77              *
1027 4C77              * LEKey
1028 4C77              *
1029 4C77              ****************************************************************
1030 4C77
1031 4C77                       Export LEKey 
1032 4C77              LEKey    PROC 
1033 4C77
1034 4C77 0B                    phd   
1035 4C78 5B                    tcd   
1036 4C79
1037 4C79 A2 08 00              ldx   #8
1038 4C7C 20 89 57              jsr   StdEntry
1039 4C7F
1040 4C7F A2 04 92 22           _ObscureCursor                 ;hide cursor
1041 4C86 20 A2 54              jsr   HideCaret                ;remove caret
1042 4C89
1043 4C89 A3 0D                 lda   13,s                     ;get modifiers
1044 4C8B 85 58                 sta   <Mods
1045 4C8D A3 0F                 lda   15,s                     ;get char
1046 4C8F 85 56                 sta   <TheChar
1047 4C91 C9 06 00              cmp   #$06                     ;control-F?
1048 4C94 F0 1F                 beq   CntlF
1049 4C96 C9 18 00              cmp   #$18                     ;control-X?
1050 4C99 F0 33                 beq   CntlX
1051 4C9B C9 19 00              cmp   #$19                     ;control-Y?
1052 4C9E F0 3A                 beq   CntlY
1053 4CA0 C9 7F 00              cmp   #$7F                     ;backspace?
1054 4CA3 F0 46                 beq   BackSpace
1055 4CA5 C9 08 00              cmp   #$08                     ;left arrow?
1056 4CA8 F0 5E                 beq   LArrow
1057 4CAA C9 15 00              cmp   #$15                     ;right arrow?
1058 4CAD F0 03                 beq   JmpRArrow
1059 4CAF 4C 42 4E              jmp   DoChar
1060 4CB2 4C A2 4D     JmpRArrow jmp   RArrow                  ;too far for a branch
1061 4CB5
1062 4CB5              ;-------------------------------------------------------------------------
1063 4CB5
1064 4CB5 20 22 57     CntlF    jsr   CmpSel                   ;see if null selection range
1065 4CB8 D0 3F                 bne   CutIt                    ;not null, so delete selection
1066 4CBA
1067 4CBA              ;since there's no selection, delete char to the right of the insertion point
1068 4CBA
1069 4CBA A0 22 00              ldy   #leSelEnd
1070 4CBD B7 1E                 lda   [<RecPtr],y              ;get selend
1071 4CBF A0 04 00              ldy   #leLength
1072 4CC2 D7 1E                 cmp   [<RecPtr],y
1073 4CC4 F0 3F                 beq   JmpDone                  ;quit if insertion point at end of line
1074 4CC6 1A                    inc   a
1075 4CC7 A0 22 00              ldy   #leSelEnd
1076 4CCA 97 1E                 sta   [<RecPtr],y              ;move selend 1 char to right
1077 4CCC 80 2B                 bra   CutIt
1078 4CCE
1079 4CCE              ;-------------------------------------------------------------------------
1080 4CCE
1081 4CCE 20 22 57     CntlX    jsr   CmpSel                   ;see if null selection range
1082 4CD1 D0 26                 bne   CutIt                    ;not null, so delete selection
1083 4CD3 A9 00 00              lda   #0                       ;is null, so delete whole line
1084 4CD6 97 1E                 sta   [<RecPtr],y              ;set selstart to 0
1085 4CD8 80 05                 bra   YCont
1086 4CDA
1087 4CDA              ;-------------------------------------------------------------------------
1088 4CDA
1089 4CDA 20 22 57     CntlY    jsr   CmpSel                   ;see if null selection range
1090 4CDD D0 1A                 bne   CutIt                    ;not null, so delete selection
1091 4CDF A0 04 00     YCont    ldy   #leLength                ;is null, so delete to end of line
1092 4CE2 B7 1E                 lda   [<RecPtr],y
1093 4CE4 A0 22 00              ldy   #leSelEnd
1094 4CE7 97 1E                 sta   [<RecPtr],y              ;set selend to end of line
1095 4CE9 80 0E                 bra   CutIt
1096 4CEB
1097 4CEB              ;-------------------------------------------------------------------------
1098 4CEB
1099 4CEB 20 22 57     BackSpace jsr   CmpSel                  ;see if null selection range
1100 4CEE D0 09                 bne   CutIt                    ;not null, so delete selection
1101 4CF0
1102 4CF0              ;since there's no selection, delete char to the left of the insertion point
1103 4CF0
1104 4CF0 B7 1E                 lda   [<RecPtr],y              ;get selstart
1105 4CF2 F0 11                 beq   JmpDone                  ;quit if insertion point at first char
1106 4CF4 B7 1E                 lda   [<RecPtr],y              ;move selstart 1 char left
1107 4CF6 3A                    dec   a
1108 4CF7 97 1E                 sta   [<RecPtr],y
1109 4CF9
1110 4CF9 20 2D 57     CutIt    jsr   SelSort                  ;sort selection ends
1111 4CFC 20 FC 56              jsr   SaveStartProc            ;save selstart
1112 4CFF 20 CA 51              jsr   DeleteGuts               ;delete selection
1113 4D02 20 29 55              jsr   ReDraw
1114 4D05 4C 5F 4E     JmpDone  jmp   Done
1115 4D08
1116 4D08              ;--------------------------------------------------------------------
1117 4D08
1118 4D08 20 33 4E     LArrow   jsr   SaveSel                  ;save current selection
1119 4D0B
1120 4D0B A5 58                 lda   <Mods
1121 4D0D 29 00 08              and   #$0800                   ;option key pressed?
1122 4D10 F0 3E                 beq   LTstApple                ;no
1123 4D12 A0 22 00     LArrow2  ldy   #leSelEnd                ;yes - so do word selection
1124 4D15 B7 1E                 lda   [<RecPtr],y              ;get current selend
1125 4D17 F0 EC                 beq   JmpDone                  ;quit if at start of line
1126 4D19 3A                    dec   a                        ;dec by 1 since left arrow
1127 4D1A 20 32 54              jsr   FindWord                 ;find the word
1128 4D1D 20 22 57              jsr   CmpSel                   ;already have a selection range?
1129 4D20 D0 0E                 bne   LSelRange                ;yes - so branch
1130 4D22 A5 3A                 lda   <WordEnd                 ;no - so set sel range to the word
1131 4D24 97 1E                 sta   [<RecPtr],y              ;new selstart
1132 4D26 AA                    tax                            ;save new selstart in X
1133 4D27 A5 58                 lda   <Mods
1134 4D29 29 00 02              and   #$0200                   ;shift key pressed?
1135 4D2C F0 02                 beq   LSelRange                ;no - so branch
1136 4D2E 86 34                 stx   <DispStart               ;yes-make sure whole word is highlighted
1137 4D30
1138 4D30 A0 22 00     LSelRange ldy   #leSelEnd
1139 4D33 A5 38                 lda   <WordStart
1140 4D35 97 1E                 sta   [<RecPtr],y              ;new selend
1141 4D37
1142 4D37 A5 58        LCont    lda   <Mods
1143 4D39 29 00 02              and   #$0200                   ;shift key pressed?
1144 4D3C F0 34                 beq   LNoShift                 ;no  - so branch
1145 4D3E A0 20 00              ldy   #leSelStart              ;yes - so check if selend and selstart
1146 4D41 B7 1E                 lda   [<RecPtr],y              ;are equal
1147 4D43 C5 38                 cmp   <WordStart
1148 4D45 D0 47                 bne   LDone                    ;not equal so done
1149 4D47 A5 34                 lda   <DispStart               ;are equal so set selstart to old selend
1150 4D49 97 1E                 sta   [<RecPtr],y              ;and go back thru previous code to move
1151 4D4B 20 33 4E              jsr   SaveSel                  ;another word to the left
1152 4D4E 80 C2                 bra   LArrow2
1153 4D50
1154 4D50 A5 58        LTstApple lda   <Mods
1155 4D52 29 00 01              and   #$0100                   ;apple key pressed?
1156 4D55 F0 08                 beq   LTstShift                ;no
1157 4D57 A9 00 00              lda   #0
1158 4D5A A0 22 00              ldy   #leSelEnd
1159 4D5D 97 1E                 sta   [<RecPtr],y              ;yes - so set selend to start of line
1160 4D5F
1161 4D5F A5 58        LTstShift lda   <Mods
1162 4D61 29 00 02              and   #$0200                   ;shift key pressed?
1163 4D64 F0 0C                 beq   LNoShift                 ;no
1164 4D66 A0 22 00              ldy   #leSelEnd
1165 4D69 B7 1E                 lda   [<RecPtr],y
1166 4D6B F0 21                 beq   LDone                    ;branch if already at start of line
1167 4D6D 3A                    dec   a                        ;extend selection left by 1 char
1168 4D6E 97 1E                 sta   [<RecPtr],y
1169 4D70 80 1C                 bra   LDone
1170 4D72
1171 4D72 20 2D 57     LNoShift jsr   SelSort                  ;sort the selection ends
1172 4D75 A0 20 00              ldy   #leSelStart
1173 4D78 B7 1E                 lda   [<RecPtr],y
1174 4D7A F0 08                 beq   LCont1                   ;branch if at start of line
1175 4D7C A0 22 00              ldy   #leSelEnd
1176 4D7F D7 1E                 cmp   [<RecPtr],y              ;is there a selection range?
1177 4D81 D0 01                 bne   LCont1                   ;yes - so position at start of selection
1178 4D83 3A                    dec   a                        ;no - so move insertion point 1 char L
1179 4D84
1180 4D84 A0 20 00     LCont1   ldy   #leSelStart
1181 4D87 97 1E                 sta   [<RecPtr],y
1182 4D89 A0 22 00     LCont2   ldy   #leSelEnd
1183 4D8C 97 1E                 sta   [<RecPtr],y
1184 4D8E A5 58        LDone    lda   <Mods
1185 4D90 29 00 02              and   #$0200                   ;shift key pressed?
1186 4D93 F0 07                 beq   LInvert                  ;no - so branch
1187 4D95 A0 22 00              ldy   #leSelEnd                ;yes
1188 4D98 B7 1E                 lda   [<RecPtr],y              ;dispend = new selend
1189 4D9A 85 36                 sta   <DispEnd
1190 4D9C              LInvert   
1191 4D9C
1192 4D9C 20 EC 54              jsr   HiLite2                  ;invert part of selection which changed
1193 4D9F
1194 4D9F 4C 5F 4E     LJmpDone jmp   Done
1195 4DA2
1196 4DA2              ;--------------------------------------------------------------------
1197 4DA2
1198 4DA2 20 33 4E     RArrow   jsr   SaveSel                  ;save current selection
1199 4DA5
1200 4DA5 A5 58                 lda   <Mods
1201 4DA7 29 00 08              and   #$0800                   ;option key pressed?
1202 4DAA F0 42                 beq   RTstApple                ;no
1203 4DAC A0 22 00     RArrow2  ldy   #leSelEnd                ;yes - so do word selection
1204 4DAF B7 1E                 lda   [<RecPtr],y              ;get current selend
1205 4DB1 A0 04 00              ldy   #leLength
1206 4DB4 D7 1E                 cmp   [<RecPtr],y
1207 4DB6 F0 E7                 beq   LJmpDone                 ;quit if at end of line
1208 4DB8 20 32 54              jsr   FindWord                 ;find the word
1209 4DBB 20 22 57              jsr   CmpSel                   ;already have a selection range?
1210 4DBE D0 0E                 bne   RSelRange                ;yes - so branch
1211 4DC0 A5 38                 lda   <WordStart               ;no - so set sel range to the word
1212 4DC2 97 1E                 sta   [<RecPtr],y              ;new selstart
1213 4DC4 AA                    tax                            ;save new selstart in X
1214 4DC5 A5 58                 lda   <Mods
1215 4DC7 29 00 02              and   #$0200                   ;shift key pressed?
1216 4DCA F0 02                 beq   RSelRange                ;no - so branch
1217 4DCC 86 34                 stx   <DispStart               ;yes-make sure whole word is highlighted
1218 4DCE
1219 4DCE A0 22 00     RSelRange ldy   #leSelEnd
1220 4DD1 A5 3A                 lda   <WordEnd
1221 4DD3 97 1E                 sta   [<RecPtr],y              ;new selend
1222 4DD5
1223 4DD5 A5 58                 lda   <Mods
1224 4DD7 29 00 02              and   #$0200                   ;shift key pressed?
1225 4DDA F0 3A                 beq   RNoShift                 ;no - so branch
1226 4DDC A0 20 00              ldy   #leSelStart              ;yes - so  check if selend and selstart
1227 4DDF B7 1E                 lda   [<RecPtr],y              ;are equal
1228 4DE1 C5 3A                 cmp   <WordEnd
1229 4DE3 D0 4B                 bne   RDone                    ;not equal so done
1230 4DE5 A5 34                 lda   <DispStart               ;are equal so set selstart to old selend
1231 4DE7 97 1E                 sta   [<RecPtr],y              ;and go back thru previous code to move
1232 4DE9 20 33 4E              jsr   SaveSel                  ;another word to the right
1233 4DEC 80 BE                 bra   RArrow2
1234 4DEE
1235 4DEE A5 58        RTstApple lda   <Mods
1236 4DF0 29 00 01              and   #$0100                   ;apple key pressed?
1237 4DF3 F0 0A                 beq   RTstShift                ;no
1238 4DF5 A0 04 00              ldy   #leLength
1239 4DF8 B7 1E                 lda   [<RecPtr],y
1240 4DFA A0 22 00              ldy   #leSelEnd
1241 4DFD 97 1E                 sta   [<RecPtr],y              ;yes - so set selend to end of line
1242 4DFF
1243 4DFF A5 58        RTstShift lda   <Mods
1244 4E01 29 00 02              and   #$0200                   ;shift key pressed?
1245 4E04 F0 10                 beq   RNoShift                 ;no
1246 4E06 A0 22 00              ldy   #leSelEnd
1247 4E09 B7 1E                 lda   [<RecPtr],y
1248 4E0B A0 04 00              ldy   #leLength
1249 4E0E D7 1E                 cmp   [<RecPtr],y
1250 4E10 F0 1E                 beq   RDone                    ;branch if at end of line
1251 4E12 1A                    inc   a                        ;extend selection right by 1 char
1252 4E13 4C 89 4D              jmp   LCont2
1253 4E16
1254 4E16 20 2D 57     RNoShift jsr   SelSort                  ;sort the selection ends
1255 4E19 A0 22 00              ldy   #leSelEnd
1256 4E1C B7 1E                 lda   [<RecPtr],y
1257 4E1E A0 04 00              ldy   #leLength
1258 4E21 D7 1E                 cmp   [<RecPtr],y              ;already at end of line?
1259 4E23 F0 08                 beq   RCont1                   ;yes
1260 4E25 A0 20 00              ldy   #leSelStart
1261 4E28 D7 1E                 cmp   [<RecPtr],y              ;is there a selection range?
1262 4E2A D0 01                 bne   RCont1                   ;yes - so position at end of selection
1263 4E2C 1A                    inc   a                        ;no - so move insertion point 1 char R
1264 4E2D
1265 4E2D 4C 84 4D     RCont1   jmp   LCont1
1266 4E30 4C 8E 4D     RDone    jmp   LDone
1267 4E33
1268 4E33              ;-------------------------------------------------------------------------
1269 4E33
1270 4E33 A0 22 00     SaveSel  ldy   #leSelEnd
1271 4E36 B7 1E                 lda   [<RecPtr],y              ;dispstart = selend
1272 4E38 85 34                 sta   <DispStart
1273 4E3A A0 20 00              ldy   #leSelStart
1274 4E3D B7 1E                 lda   [<RecPtr],y              ;dispend = selstart
1275 4E3F 85 36                 sta   <DispEnd
1276 4E41 60                    rts   
1277 4E42
1278 4E42              ;-------------------------------------------------------------------------
1279 4E42
1280 4E42 A9 01 00     DoChar   lda   #1
1281 4E45 85 18                 sta   <TextLength
1282 4E47 64 16                 stz   <TextPtr+2               ;set up ptr to char
1283 4E49 18                    clc   
1284 4E4A 7B                    tdc   
1285 4E4B 69 56 00              adc   #TheChar
1286 4E4E 85 14                 sta   <TextPtr
1287 4E50 20 2D 57              jsr   SelSort                  ;sort selection ends
1288 4E53 20 D6 54              jsr   HiLite                   ;remove selection
1289 4E56 20 FC 56              jsr   SaveStartProc            ;save selstart
1290 4E59 20 13 52              jsr   PasteGuts                ;insert char
1291 4E5C 20 29 55              jsr   ReDraw
1292 4E5F
1293 4E5F 20 7E 54     Done     jsr   ShowCaret
1294 4E62 20 2C 58              jsr   StdExit
1295 4E65 4C 5A 57              jmp   StdEnd
1296 4E68
1297 4E68                       EndP 
1298 4E68
1299 4E68
1300 4E68
1301 4E68              ****************************************************************
1302 4E68              *
1303 4E68              * LECut
1304 4E68              *
1305 4E68              ****************************************************************
1306 4E68
1307 4E68                       Export LECut 
1308 4E68              LECut    PROC 
1309 4E68
1310 4E68 0B                    phd   
1311 4E69 5B                    tcd   
1312 4E6A
1313 4E6A A3 0B                 lda   11,s                     ;push handle
1314 4E6C 48                    pha   
1315 4E6D A3 0B                 lda   11,s
1316 4E6F 48                    pha   
1317 4E70 22 89 4E FC           jsl   xLECopy                  ;copy selection to scrap
1318 4E74 B0 0F                 bcs   GotErr
1319 4E76
1320 4E76 A3 0B                 lda   11,s                     ;push handle
1321 4E78 48                    pha   
1322 4E79 A3 0B                 lda   11,s
1323 4E7B 48                    pha   
1324 4E7C 22 8F 4E FC           jsl   xLEDelete                ;delete selection
1325 4E80 B0 03                 bcs   GotErr
1326 4E82
1327 4E82 4C 7B 57              jmp   StdEnd4
1328 4E85
1329 4E85 AA           GotErr   tax                            ;xfer error code to X
1330 4E86 4C 82 57              jmp   StdErr4                  ;return the error
1331 4E89
1332 4E89 7B           xLECopy  tdc   
1333 4E8A 22 95 4E FC           jsl   LECopy
1334 4E8E 6B                    rtl   
1335 4E8F
1336 4E8F 7B           xLEDelete tdc   
1337 4E90 22 F6 4E FC           jsl   LEDelete
1338 4E94 6B                    rtl   
1339 4E95
1340 4E95                       EndP 
1341 4E95
1342 4E95
1343 4E95              ****************************************************************
1344 4E95              *
1345 4E95              * LECopy
1346 4E95              *
1347 4E95              *
1348 4E95              * Change History
1349 4E95              *
1350 4E95              * 16 Jun 88         Steven Glass
1351 4E95              *
1352 4E95              * Value of scrap length is now checked before moving any data.
1353 4E95              * this prevents data from being trashed.
1354 4E95              *
1355 4E95              ****************************************************************
1356 4E95
1357 4E95                       Export LECopy 
1358 4E95              LECopy   PROC 
1359 4E95
1360 4E95 0B                    phd   
1361 4E96 5B                    tcd   
1362 4E97
1363 4E97 A2 04 00              ldx   #4
1364 4E9A 20 89 57              jsr   StdEntry
1365 4E9D
1366 4E9D 20 2D 57              jsr   SelSort                  ;sort selection ends
1367 4EA0 20 16 57              jsr   CalcSelLen               ;calculate length of selection range
1368 4EA3 85 2E                 sta   <ScrapLength             ;and store as new scraplength
1369 4EA5
1370 4EA5 C9 00 00              cmp   #0                       ; make sure that there is something to move
1371 4EA8 F0 19                 beq   Done
1372 4EAA
1373 4EAA 20 04 57              jsr   CalcStartPtr             ;StartPtr now points to start of sel
1374 4EAD 20 B9 58              jsr   LockScrap                ;TextPtr now points to scrap
1375 4EB0
1376 4EB0 A4 2E                 ldy   <ScrapLength
1377 4EB2 98                    tya   
1378 4EB3 6A                    ror   a
1379 4EB4 B0 01                 bcs   DecOne                   ;branch if length is odd
1380 4EB6 88                    dey   
1381 4EB7 88           DecOne   dey   
1382 4EB8
1383 4EB8 B7 30        Loop     lda   [<StartPtr],y            ;copy selection into scrap
1384 4EBA 97 14                 sta   [<TextPtr],y
1385 4EBC 88                    dey   
1386 4EBD 88                    dey   
1387 4EBE 10 F8                 bpl   Loop
1388 4EC0
1389 4EC0 20 CF 58              jsr   UnLockScrap
1390 4EC3
1391 4EC3 20 2C 58     Done     jsr   StdExit
1392 4EC6 4C 5A 57              jmp   StdEnd
1393 4EC9
1394 4EC9                       EndP 
1395 4EC9
1396 4EC9
1397 4EC9              ****************************************************************
1398 4EC9              *
1399 4EC9              * LEPaste
1400 4EC9              *
1401 4EC9              ****************************************************************
1402 4EC9
1403 4EC9                       Export LEPaste 
1404 4EC9              LEPaste  PROC 
1405 4EC9
1406 4EC9 0B                    phd   
1407 4ECA 5B                    tcd   
1408 4ECB
1409 4ECB A2 04 00              ldx   #4
1410 4ECE 20 89 57              jsr   StdEntry
1411 4ED1
1412 4ED1 20 2D 57              jsr   SelSort                  ;sort selection ends
1413 4ED4 20 A2 54              jsr   HideCaret
1414 4ED7 20 D6 54              jsr   HiLite                   ;remove selection
1415 4EDA 20 FC 56              jsr   SaveStartProc            ;save selstart
1416 4EDD
1417 4EDD 20 B9 58              jsr   LockScrap                ;TextPtr now points to scrap
1418 4EE0 A5 2E                 lda   <ScrapLength
1419 4EE2 85 18                 sta   <TextLength
1420 4EE4 20 13 52              jsr   PasteGuts                ;paste scrap into line
1421 4EE7 20 CF 58              jsr   UnLockScrap
1422 4EEA
1423 4EEA 20 29 55              jsr   ReDraw
1424 4EED 20 7E 54              jsr   ShowCaret
1425 4EF0
1426 4EF0 20 2C 58     Done     jsr   StdExit
1427 4EF3 4C 5A 57              jmp   StdEnd
1428 4EF6
1429 4EF6                       EndP 
1430 4EF6
1431 4EF6
1432 4EF6              ****************************************************************
1433 4EF6              *
1434 4EF6              * LEDelete
1435 4EF6              *
1436 4EF6              ****************************************************************
1437 4EF6
1438 4EF6                       Export LEDelete 
1439 4EF6              LEDelete PROC 
1440 4EF6
1441 4EF6 0B                    phd   
1442 4EF7 5B                    tcd   
1443 4EF8
1444 4EF8 A2 04 00              ldx   #4
1445 4EFB 20 89 57              jsr   StdEntry
1446 4EFE
1447 4EFE 20 2D 57              jsr   SelSort                  ;sort selection ends
1448 4F01 20 A2 54              jsr   HideCaret
1449 4F04 20 FC 56              jsr   SaveStartProc            ;save selstart
1450 4F07 20 CA 51              jsr   DeleteGuts               ;delete the selection
1451 4F0A 20 29 55              jsr   ReDraw                   ;redraw from saved selstart
1452 4F0D 20 7E 54              jsr   ShowCaret
1453 4F10
1454 4F10 20 2C 58              jsr   StdExit
1455 4F13 4C 5A 57              jmp   StdEnd
1456 4F16
1457 4F16                       EndP 
1458 4F16
1459 4F16
1460 4F16              ****************************************************************
1461 4F16              *
1462 4F16              * LEInsert
1463 4F16              *
1464 4F16              ****************************************************************
1465 4F16
1466 4F16                       Export LEInsert 
1467 4F16              LEInsert PROC 
1468 4F16
1469 4F16 0B                    phd   
1470 4F17 5B                    tcd   
1471 4F18
1472 4F18 A2 0A 00              ldx   #10
1473 4F1B 20 89 57              jsr   StdEntry
1474 4F1E
1475 4F1E 20 2D 57              jsr   SelSort                  ;sort selection ends
1476 4F21 20 A2 54              jsr   HideCaret
1477 4F24 20 D6 54              jsr   HiLite                   ;remove selection
1478 4F27
1479 4F27 A3 0D                 lda   13,s
1480 4F29 A0 06 00              ldy   #leMaxLength
1481 4F2C D7 1E                 cmp   [<RecPtr],y              ;is length > max line length?
1482 4F2E 90 02                 bcc   OK                       ;no
1483 4F30 B7 1E                 lda   [<RecPtr],y              ;yes - so set it to max line length
1484 4F32 85 18        OK       sta   <TextLength
1485 4F34 A3 0F                 lda   15,s                     ;get ptr to text to insert
1486 4F36 85 14                 sta   <TextPtr
1487 4F38 A3 11                 lda   17,s
1488 4F3A 85 16                 sta   <TextPtr+2
1489 4F3C
1490 4F3C 20 FC 56              jsr   SaveStartProc            ;save selstart
1491 4F3F 20 7A 52              jsr   InsertGuts               ;insert the text
1492 4F42 20 29 55              jsr   ReDraw                   ;redraw from saved selstart
1493 4F45 20 7E 54              jsr   ShowCaret
1494 4F48 20 D6 54              jsr   HiLite                   ;restore the selection
1495 4F4B
1496 4F4B 20 2C 58     Done     jsr   StdExit
1497 4F4E 4C 5A 57              jmp   StdEnd
1498 4F51
1499 4F51                       EndP 
1500 4F51
1501 4F51
1502 4F51              ****************************************************************
1503 4F51              *
1504 4F51              * LEUpdate
1505 4F51              *
1506 4F51              ****************************************************************
1507 4F51
1508 4F51                       Export LEUpdate 
1509 4F51              LEUpdate PROC 
1510 4F51
1511 4F51 0B                    phd   
1512 4F52 5B                    tcd   
1513 4F53
1514 4F53 A2 04 00              ldx   #4
1515 4F56 20 89 57              jsr   StdEntry
1516 4F59
1517 4F59 20 A2 54              jsr   HideCaret                ;** bug fix 2-24-87 CAE **
1518 4F5C
1519 4F5C 64 34                 stz   <DispStart
1520 4F5E 20 29 55              jsr   ReDraw                   ;redraw from start of line
1521 4F61
1522 4F61 20 7E 54              jsr   ShowCaret                ;** bug fix 2-24-87 CAE **
1523 4F64 20 D6 54              jsr   HiLite                   ;reshow selection
1524 4F67
1525 4F67 20 2C 58     Done     jsr   StdExit
1526 4F6A 4C 5A 57              jmp   StdEnd
1527 4F6D
1528 4F6D                       EndP 
1529 4F6D
1530 4F6D
1531 4F6D              ****************************************************************
1532 4F6D              *
1533 4F6D              * LETextBox
1534 4F6D              *
1535 4F6D              ****************************************************************
1536 4F6D
1537 4F6D                       Export LETextBox 
1538 4F6D              LETextBox PROC 
1539 4F6D
1540 4F6D              RectPtr  equ StartPtr 
1541 4F6D              RectWidth equ TempPtr2 
1542 4F6D              NumChars equ TempPtr2+2 
1543 4F6D              H1       equ TempWord1 
1544 4F6D              V1       equ TempWord2 
1545 4F6D
1546 4F6D 0B                    phd   
1547 4F6E 5B                    tcd   
1548 4F6F
1549 4F6F A3 0F                 lda   15,s                     ;get length of text
1550 4F71 D0 03                 bne   OK
1551 4F73 4C 75 50              jmp   Done                     ;quit if 0
1552 4F76
1553 4F76 85 18        OK       sta   <TextLength              ;save text length
1554 4F78
1555 4F78 A3 0B                 lda   11,s                     ;get ptr to rect and save
1556 4F7A 85 30                 sta   <RectPtr
1557 4F7C A3 0D                 lda   13,s
1558 4F7E 85 32                 sta   <RectPtr+2
1559 4F80
1560 4F80 A3 11                 lda   17,s                     ;get ptr to text and save
1561 4F82 85 14                 sta   <TextPtr
1562 4F84 A3 13                 lda   19,s
1563 4F86 85 16                 sta   <TextPtr+2
1564 4F88
1565 4F88 64 34                 stz   <DispStart               ;init char offset to 0
1566 4F8A
1567 4F8A F4 00 00              PushWord #0                    ;space for result
1568 4F8D F4 00 00              PushWord #0 
1569 4F90 D4 32 D4 30           PushZLong <RectPtr             ;destrect
1570 4F94 D4 32 D4 30           PushZLong <RectPtr             ;viewrect - make max text len as small
1571 4F98 F4 01 00              PushWord #1                    ;as possible since it won't be used
1572 4F9B 22 78 50 FC           jsl   xLENew                   ;create a new edit record
1573 4F9F 90 0A                 bcc   OKNew
1574 4FA1 AA                    tax                            ;xfer error code to X
1575 4FA2 68                    pla                            ;pull result off stack
1576 4FA3 68                    pla   
1577 4FA4 A0 0C 00              ldy   #12                      ;# bytes of params for LETextBox
1578 4FA7 5C B3 FC FE           jml   ErrOut                   ;return the error
1579 4FAB
1580 4FAB 68           OKNew    pla                            ;get handle to record and save
1581 4FAC 85 1A                 sta   <RecHandle
1582 4FAE 68                    pla   
1583 4FAF 85 1C                 sta   <RecHandle+2
1584 4FB1
1585 4FB1 A2 0C 00              ldx   #12
1586 4FB4 20 91 57              jsr   StdEntry2
1587 4FB7
1588 4FB7 D4 32 D4 30           PushZLong <RectPtr 
1589 4FBB A2 04 55 22           _EraseRect                     ;erase the rect
1590 4FC2
1591 4FC2 A0 0E 00              ldy   #leDestRect+6
1592 4FC5 B7 1E                 lda   [<RecPtr],y              ;get H2 of the rect
1593 4FC7 38                    sec   
1594 4FC8 A0 0A 00              ldy   #leDestRect+2
1595 4FCB F7 1E                 sbc   [<RecPtr],y              ;subtract H1 of the rect
1596 4FCD 85 08                 sta   <RectWidth               ;save width of the rect
1597 4FCF
1598 4FCF B7 1E                 lda   [<RecPtr],y              ;get H1 of the rect
1599 4FD1 85 00                 sta   <H1                      ;and save
1600 4FD3 A0 08 00              ldy   #leDestRect
1601 4FD6 B7 1E                 lda   [<RecPtr],y              ;get V1 of the rect
1602 4FD8 18                    clc   
1603 4FD9 A0 1E 00              ldy   #leBaseHite
1604 4FDC 77 1E                 adc   [<RecPtr],y              ;and calculate the base line
1605 4FDE 85 02                 sta   <V1                      ;and save
1606 4FE0
1607 4FE0 18           NewLine  clc   
1608 4FE1 A5 14                 lda   <TextPtr                 ;get ptr to start of text
1609 4FE3 65 34                 adc   <DispStart               ;and add current offset
1610 4FE5 85 30                 sta   <StartPtr                ;to calculate ptr to start of line
1611 4FE7 A5 16                 lda   <TextPtr+2
1612 4FE9 69 00 00              adc   #0
1613 4FEC 85 32                 sta   <StartPtr+2
1614 4FEE
1615 4FEE 64 0A                 stz   <NumChars                ;init '# chars in line' to 0
1616 4FF0 A4 34                 ldy   <DispStart               ;get offset to first char in line
1617 4FF2 B7 14        Loop     lda   [<TextPtr],y             ;read the char
1618 4FF4 C8                    iny                            ;inc char offset
1619 4FF5 29 FF 00              and   #$00FF                   ;mask off the hi byte of the char
1620 4FF8 C9 0D 00              cmp   #$0D                     ;is the char a CR?
1621 4FFB F0 06                 beq   GotCR                    ;yes
1622 4FFD E6 0A                 inc   <NumChars                ;no - so inc '# chars in line'
1623 4FFF C4 18                 cpy   <TextLength              ;are we at the end of the text?
1624 5001 90 EF                 bcc   Loop                     ;no - so check next char
1625 5003
1626 5003 84 34        GotCR    sty   <DispStart               ;save offset to start of next line
1627 5005 A5 0A                 lda   <NumChars                ;get # chars in line
1628 5007 F0 48                 beq   NoChars                  ;branch if no chars in line
1629 5009
1630 5009 A3 09                 lda   9,s                      ;get justification
1631 500B D0 04                 bne   NotLeft
1632 500D D4 00                 PushZWord <H1                  ;left justified
1633 500F 80 2A                 bra   Cont
1634 5011
1635 5011              NotLeft   
1636 5011 F4 00 00              PushWord #0 
1637 5014 D4 32 D4 30           PushZLong <StartPtr            ;ptr to start of line
1638 5018 D4 0A                 PushZWord <NumChars            ;# of chars in line
1639 501A A2 04 AB 22           _TextWidth                     ;measure width of line
1640 5021 38                    sec   
1641 5022 A5 08                 lda   <RectWidth               ;get width of rect
1642 5024 E3 01                 sbc   1,s                      ;subtract width of line
1643 5026 B0 03                 bcs   OK2                      ;branch if linewidth < rectwidth
1644 5028 A9 00 00              lda   #0
1645 502B 83 01        OK2      sta   1,s                      ;save diff between widths
1646 502D A3 0B                 lda   11,s                     ;get justification
1647 502F 30 05                 bmi   Adjust                   ;branch if right justify
1648 5031 A3 01                 lda   1,s                      ;get diff
1649 5033 4A                    lsr   a                        ;divide by 2
1650 5034 83 01                 sta   1,s                      ;and save
1651 5036 68           Adjust   pla                            ;get diff
1652 5037 18                    clc   
1653 5038 65 00                 adc   <H1                      ;add to H1
1654 503A 48                    pha                            ;and push
1655 503B
1656 503B D4 02        Cont     PushZWord <V1 
1657 503D A2 04 3A 22           _MoveTo                        ;position pen
1658 5044
1659 5044 D4 32 D4 30           PushZLong <StartPtr            ;ptr to start of line
1660 5048 D4 0A                 PushZWord <NumChars            ;# chars in line
1661 504A A2 04 A7 22           _DrawText                      ;draw the text
1662 5051
1663 5051 A5 34        NoChars  lda   <DispStart               ;get current char offset
1664 5053 C5 18                 cmp   <TextLength              ;at end of text?
1665 5055 B0 0D                 bcs   NoMore                   ;yes - so done
1666 5057
1667 5057 18                    clc   
1668 5058 A5 02                 lda   <V1                      ;get V1 for line just drawn
1669 505A A0 1C 00              ldy   #leLineHite
1670 505D 77 1E                 adc   [<RecPtr],y              ;add linehite to calculate V1 for
1671 505F 85 02                 sta   <V1                      ;next line and save
1672 5061 4C E0 4F              jmp   NewLine
1673 5064
1674 5064 20 2C 58     NoMore   jsr   StdExit
1675 5067
1676 5067 D4 1C D4 1A           PushZLong <RecHandle 
1677 506B 22 7E 50 FC           jsl   xLEDispose               ;dispose of edit record
1678 506F 90 04                 bcc   Done
1679 5071 AA                    tax                            ;xfer error code to X
1680 5072 4C 60 57              jmp   StdErr                   ;LEDispose returned an error
1681 5075
1682 5075 4C 5A 57     Done     jmp   StdEnd
1683 5078
1684 5078              ;-------------------------------------------------------------------------------
1685 5078
1686 5078 7B           xLENew   tdc   
1687 5079 22 AE 48 FC           jsl   LENew
1688 507D 6B                    rtl   
1689 507E
1690 507E 7B           xLEDispose tdc   
1691 507F 22 B3 49 FC           jsl   LEDispose
1692 5083 6B                    rtl   
1693 5084
1694 5084                       EndP 
1695 5084
1696 5084
1697 5084              ****************************************************************
1698 5084              *
1699 5084              * LEFromScrap
1700 5084              *
1701 5084              ****************************************************************
1702 5084
1703 5084                       Export LEFromScrap 
1704 5084              LEFromScrap PROC 
1705 5084
1706 5084 0B                    phd   
1707 5085 5B                    tcd   
1708 5086
1709 5086 F4 00 00 F4           PushLong #0 
1710 508C F4 00 00              PushWord #ScrapType            ;type = text
1711 508F A2 16 0F 22           _GetScrapSize                  ;get size of desk scrap
1712 5096 B0 23                 bcs   GotErr
1713 5098
1714 5098 FA                    plx                            ;get lo word of size
1715 5099 68                    pla                            ;get hi word of size
1716 509A D0 05                 bne   TooBig                   ;if not 0 then too big
1717 509C E0 01 01              cpx   #MaxChars+1
1718 509F 90 06                 bcc   OK
1719 50A1 A2 04 14     TooBig   ldx   #DSErr                   ;error - desk scrap too big
1720 50A4 4C 74 57              jmp   StdErr0
1721 50A7
1722 50A7 86 2E        OK       stx   <ScrapLength             ;new scrap length
1723 50A9
1724 50A9 F4 00 00 F4           PushLong #0 
1725 50AF F4 00 00              PushWord #ScrapType            ;type = text
1726 50B2 A2 16 0E 22           _GetScrapHandle                ;get handle to desk scrap
1727 50B9 90 06                 bcc   NoErr
1728 50BB AA           GotErr   tax                            ;xfer error code to X
1729 50BC 68                    pla                            ;pull result
1730 50BD 68                    pla   
1731 50BE 4C 74 57              jmp   StdErr0                  ;return the error
1732 50C1
1733 50C1 68           NoErr    pla   
1734 50C2 85 22                 sta   <LineHandle              ;save in linehandle
1735 50C4 68                    pla   
1736 50C5 85 24                 sta   <LineHandle+2
1737 50C7 20 98 58              jsr   LockLine2                ;LinePtr now points to desk scrap
1738 50CA
1739 50CA 20 B9 58              jsr   LockScrap                ;TextPtr now points to linedit scrap
1740 50CD
1741 50CD A4 2E                 ldy   <ScrapLength             ;get # bytes to copy
1742 50CF 98                    tya   
1743 50D0 6A                    ror   a
1744 50D1 B0 01                 bcs   DecOne                   ;branch if length is odd
1745 50D3 88                    dey   
1746 50D4 88           DecOne   dey   
1747 50D5
1748 50D5 B7 26        Loop     lda   [<LinePtr],y             ;copy desk scrap into linedit scrap
1749 50D7 97 14                 sta   [<TextPtr],y
1750 50D9 88                    dey   
1751 50DA 88                    dey   
1752 50DB 10 F8                 bpl   Loop
1753 50DD
1754 50DD 20 AE 58              jsr   UnLockLine
1755 50E0 20 CF 58              jsr   UnLockScrap
1756 50E3 4C 6D 57     Fini     jmp   StdEnd0
1757 50E6
1758 50E6                       EndP 
1759 50E6
1760 50E6
1761 50E6              ****************************************************************
1762 50E6              *
1763 50E6              * LEToScrap
1764 50E6              *
1765 50E6              ****************************************************************
1766 50E6
1767 50E6                       Export LEToScrap 
1768 50E6              LEToScrap PROC 
1769 50E6
1770 50E6 0B                    phd   
1771 50E7 5B                    tcd   
1772 50E8
1773 50E8 A2 16 0B 22           _ZeroScrap                     ;zero out desk scrap
1774 50EF
1775 50EF 20 B9 58              jsr   LockScrap                ;TextPtr now points to linedit scrap
1776 50F2 F4 00 00              PushWord #0                    ;hi word of length
1777 50F5 D4 2E                 PushZWord <ScrapLength         ;lo word of length
1778 50F7 F4 00 00              PushWord #ScrapType            ;type of scrap = text
1779 50FA D4 16 D4 14           PushZLong <TextPtr             ;ptr to linedit scrap
1780 50FE A2 16 0C 22           _PutScrap                      ;copy linedit scrap to desk scrap
1781 5105 90 07                 bcc   OK
1782 5107 AA                    tax                            ;xfer error code to X
1783 5108 20 CF 58              jsr   UnLockScrap              ;clean up
1784 510B 4C 74 57              jmp   StdErr0                  ;return the error
1785 510E
1786 510E 20 CF 58     OK       jsr   UnLockScrap
1787 5111 4C 6D 57              jmp   StdEnd0
1788 5114
1789 5114                       EndP 
1790 5114
1791 5114
1792 5114              ****************************************************************
1793 5114              *
1794 5114              * LEScrapHandle
1795 5114              *
1796 5114              ****************************************************************
1797 5114
1798 5114                       Export LEScrapHandle 
1799 5114              LEScrapHandle PROC 
1800 5114
1801 5114 0B                    phd   
1802 5115 5B                    tcd   
1803 5116
1804 5116 A5 2C                 lda   <ScrapHandle+2           ;return handle to scrap
1805 5118 83 0B                 sta   11,s
1806 511A A5 2A                 lda   <ScrapHandle
1807 511C 83 09                 sta   9,s
1808 511E 4C 6D 57              jmp   StdEnd0
1809 5121
1810 5121                       EndP 
1811 5121
1812 5121
1813 5121              ****************************************************************
1814 5121              *
1815 5121              * LEGetScrapLen
1816 5121              *
1817 5121              ****************************************************************
1818 5121
1819 5121                       Export LEGetScrapLen 
1820 5121              LEGetScrapLen PROC 
1821 5121
1822 5121 0B                    phd   
1823 5122 5B                    tcd   
1824 5123
1825 5123 A5 2E                 lda   <ScrapLength             ;return length of scrap
1826 5125 83 09                 sta   9,s
1827 5127 4C 6D 57              jmp   StdEnd0
1828 512A
1829 512A                       EndP 
1830 512A
1831 512A
1832 512A              ****************************************************************
1833 512A              *
1834 512A              * LESetScrapLen
1835 512A              *
1836 512A              ****************************************************************
1837 512A
1838 512A                       Export LESetScrapLen 
1839 512A              LESetScrapLen PROC 
1840 512A
1841 512A 0B                    phd   
1842 512B 5B                    tcd   
1843 512C
1844 512C A3 09                 lda   9,s                      ;get new scrap length
1845 512E C9 00 01              cmp   #MaxChars                ;too big?
1846 5131 90 03                 bcc   OK                       ;no
1847 5133 A9 00 01              lda   #MaxChars                ;yes - so set to max line size
1848 5136 85 2E        OK       sta   <ScrapLength
1849 5138 A0 02 00              ldy   #2                       ;param size
1850 513B 5C B0 FC FE           jml   EndCall
1851 513F
1852 513F                       EndP 
1853 513F
1854 513F
1855 513F              ****************************************************************
1856 513F              *
1857 513F              * LESetHilite
1858 513F              *
1859 513F              ****************************************************************
1860 513F
1861 513F                       Export LESetHilite 
1862 513F              LESetHilite PROC 
1863 513F
1864 513F 0B                    phd   
1865 5140 5B                    tcd   
1866 5141
1867 5141 F4 2E 00              PushWord #leHiliteHook         ;push index to hilitehook field
1868 5144 4C 4C 51              jmp   HookCommon
1869 5147
1870 5147                       EndP 
1871 5147
1872 5147
1873 5147              ****************************************************************
1874 5147              *
1875 5147              * LESetCaret
1876 5147              *
1877 5147              ****************************************************************
1878 5147
1879 5147                       Export LESetCaret 
1880 5147              LESetCaret PROC 
1881 5147
1882 5147 0B                    phd   
1883 5148 5B                    tcd   
1884 5149
1885 5149 F4 32 00              PushWord #leCaretHook          ;push index to carethook field
1886 514C
1887 514C                       Export HookCommon 
1888 514C              HookCommon  
1889 514C A3 0B                 lda   11,s
1890 514E 85 1A                 sta   <RecHandle               ;get rec handle
1891 5150 A3 0D                 lda   13,s
1892 5152 85 1C                 sta   <RecHandle+2
1893 5154 20 6C 58              jsr   LockRec                  ;and lock the rec
1894 5157
1895 5157 7A                    ply                            ;get index to correct field
1896 5158 A3 0D                 lda   13,s                     ;store new routine address in field
1897 515A 97 1E                 sta   [<RecPtr],y
1898 515C C8                    iny   
1899 515D C8                    iny   
1900 515E A3 0F                 lda   15,s
1901 5160 97 1E                 sta   [<RecPtr],y
1902 5162
1903 5162 20 82 58              jsr   UnLockRec
1904 5165 A0 08 00              ldy   #8                       ;param size
1905 5168 5C B0 FC FE           jml   EndCall
1906 516C
1907 516C                       EndP 
1908 516C
1909 516C
1910 516C              ****************************************************************
1911 516C              *
1912 516C              * LESetJust
1913 516C              *
1914 516C              ****************************************************************
1915 516C
1916 516C                       Export LESetJust 
1917 516C              LESetJust PROC                          ;** call added 3-6-87 CAE **
1918 516C
1919 516C 0B                    phd   
1920 516D 5B                    tcd   
1921 516E
1922 516E A3 09                 lda   9,s
1923 5170 85 1A                 sta   <RecHandle               ;get rec handle
1924 5172 A3 0B                 lda   11,s
1925 5174 85 1C                 sta   <RecHandle+2
1926 5176 20 6C 58              jsr   LockRec                  ;and lock the rec
1927 5179
1928 5179 A3 0D                 lda   13,s                     ;get new text justification
1929 517B A0 36 00              ldy   #leJust
1930 517E 97 1E                 sta   [<RecPtr],y              ;and save in record
1931 5180
1932 5180 20 82 58              jsr   UnLockRec
1933 5183 A0 06 00              ldy   #6                       ;param size
1934 5186 5C B0 FC FE           jml   EndCall
1935 518A
1936 518A                       EndP 
1937 518A
1938 518A
1939 518A              ****************************************************************
1940 518A              *
1941 518A              * LEGetTextHand
1942 518A              *
1943 518A              ****************************************************************
1944 518A
1945 518A                       Export LEGetTextHand 
1946 518A              LEGetTextHand PROC                      ;** call added 4-24-87 CAE **
1947 518A
1948 518A 0B                    phd   
1949 518B 5B                    tcd   
1950 518C
1951 518C A3 09                 lda   9,s
1952 518E 85 1A                 sta   <RecHandle               ;get rec handle
1953 5190 A3 0B                 lda   11,s
1954 5192 85 1C                 sta   <RecHandle+2
1955 5194 20 6C 58              jsr   LockRec                  ;and lock the rec
1956 5197
1957 5197 A7 1E                 lda   [<RecPtr]                ;return handle to line
1958 5199 83 0D                 sta   13,s
1959 519B A0 02 00              ldy   #2
1960 519E B7 1E                 lda   [<RecPtr],y
1961 51A0 83 0F                 sta   15,s
1962 51A2
1963 51A2 20 82 58              jsr   UnLockRec                ;unlock the rec
1964 51A5 A0 04 00              ldy   #4                       ;param size
1965 51A8 5C B0 FC FE           jml   EndCall
1966 51AC
1967 51AC                       EndP 
1968 51AC
1969 51AC
1970 51AC              ****************************************************************
1971 51AC              *
1972 51AC              * LEGetTextLen
1973 51AC              *
1974 51AC              ****************************************************************
1975 51AC
1976 51AC                       Export LEGetTextLen 
1977 51AC              LEGetTextLen PROC                       ;** call added 4-24-87 CAE **
1978 51AC
1979 51AC 0B                    phd   
1980 51AD 5B                    tcd   
1981 51AE
1982 51AE A3 09                 lda   9,s
1983 51B0 85 1A                 sta   <RecHandle               ;get rec handle
1984 51B2 A3 0B                 lda   11,s
1985 51B4 85 1C                 sta   <RecHandle+2
1986 51B6 20 6C 58              jsr   LockRec                  ;and lock the rec
1987 51B9
1988 51B9 A0 04 00              ldy   #leLength
1989 51BC B7 1E                 lda   [<RecPtr],y              ;return length of line
1990 51BE 83 0D                 sta   13,s
1991 51C0
1992 51C0 20 82 58              jsr   UnLockRec                ;unlock the rec
1993 51C3 A0 04 00              ldy   #4                       ;param size
1994 51C6 5C B0 FC FE           jml   EndCall
1995 51CA
1996 51CA                       EndP 
1997 51CA
1998 51CA
1999 51CA              ****************************************************************
2000 51CA              *
2001 51CA              * DeleteGuts
2002 51CA              *
2003 51CA              ****************************************************************
2004 51CA
2005 51CA                       Export DeleteGuts 
2006 51CA              DeleteGuts PROC 
2007 51CA
2008 51CA              SelLength equ TempWord1 
2009 51CA              MovLength equ TempWord2 
2010 51CA              EndPtr   equ TempPtr1 
2011 51CA
2012 51CA 20 16 57              jsr   CalcSelLen               ;calculate length of selection range
2013 51CD F0 43                 beq   Done                     ;quit if length = 0
2014 51CF 85 00                 sta   <SelLength               ;save length
2015 51D1
2016 51D1 A0 04 00              ldy   #leLength                ;get length of line
2017 51D4 B7 1E                 lda   [<RecPtr],y
2018 51D6 38                    sec   
2019 51D7 A0 22 00              ldy   #leSelEnd                ;subtract selend to
2020 51DA F7 1E                 sbc   [<RecPtr],y              ;calculate # of chars to move
2021 51DC F0 20                 beq   NoMove                   ;branch if no text to move
2022 51DE 85 02                 sta   <MovLength
2023 51E0
2024 51E0 20 04 57              jsr   CalcStartPtr             ;StartPtr now points to start of sel
2025 51E3
2026 51E3 18                    clc   
2027 51E4 A5 00                 lda   <SelLength               ;get length of selection
2028 51E6 65 30                 adc   <StartPtr                ;calculate ptr to end of selection
2029 51E8 85 04                 sta   <EndPtr
2030 51EA A9 00 00              lda   #0
2031 51ED 65 32                 adc   <StartPtr+2
2032 51EF 85 06                 sta   <EndPtr+2
2033 51F1
2034 51F1 A0 00 00              ldy   #0
2035 51F4 B7 04        Loop     lda   [<EndPtr],y              ;move text from end of selection
2036 51F6 97 30                 sta   [<StartPtr],y            ;to start of selection thereby deleting
2037 51F8 C8                    iny                            ;the selection range
2038 51F9 C8                    iny   
2039 51FA C4 02                 cpy   <MovLength               ;done with move?
2040 51FC 90 F6                 bcc   Loop                     ;no
2041 51FE
2042 51FE A0 20 00     NoMove   ldy   #leSelStart
2043 5201 B7 1E                 lda   [<RecPtr],y
2044 5203 A0 22 00              ldy   #leSelEnd
2045 5206 97 1E                 sta   [<RecPtr],y              ;set selend equal to selstart
2046 5208
2047 5208 A0 04 00              ldy   #leLength
2048 520B B7 1E                 lda   [<RecPtr],y              ;get length of line
2049 520D 38                    sec   
2050 520E E5 00                 sbc   <SelLength               ;subtract amount deleted
2051 5210 97 1E                 sta   [<RecPtr],y              ;save as new length
2052 5212
2053 5212 60           Done     rts   
2054 5213
2055 5213                       EndP 
2056 5213
2057 5213
2058 5213              ****************************************************************
2059 5213              *
2060 5213              * PasteGuts
2061 5213              *
2062 5213              ****************************************************************
2063 5213
2064 5213                       Export PasteGuts 
2065 5213              PasteGuts PROC 
2066 5213
2067 5213              SelLength equ TempWord1 
2068 5213              Remainder equ TempWord2 
2069 5213
2070 5213 20 16 57              jsr   CalcSelLen               ;calculate length of selection range
2071 5216 85 00                 sta   <SelLength               ;and save
2072 5218
2073 5218 20 04 57              jsr   CalcStartPtr             ;StartPtr now points to start of sel
2074 521B
2075 521B A6 00                 ldx   <SelLength               ;determine whether text length is > or
2076 521D 38                    sec                            ;< selection length and load X with the
2077 521E A5 18                 lda   <TextLength              ;smaller of the two
2078 5220 E5 00                 sbc   <SelLength
2079 5222 B0 02                 bcs   Cont
2080 5224 A6 18                 ldx   <TextLength
2081 5226 85 02        Cont     sta   <Remainder               ;save remainder
2082 5228 8A                    txa                            ;get replace length back
2083 5229 F0 24                 beq   EndLoop                  ;replace length = 0
2084 522B A0 20 00              ldy   #leSelStart
2085 522E 18                    clc   
2086 522F 77 1E                 adc   [<RecPtr],y              ;point selstart to end of replacement
2087 5231 97 1E                 sta   [<RecPtr],y
2088 5233
2089 5233 9B                    txy   
2090 5234 88                    dey   
2091 5235 88                    dey   
2092 5236 10 0D                 bpl   Loop
2093 5238 A0 00 00              ldy   #0                       ;replace length = 1
2094 523B E2 30                 sep   #$30                     ;8 bit mode
2095 523D B7 14                 lda   [<TextPtr],y
2096 523F 97 30                 sta   [<StartPtr],y
2097 5241 C2 30                 rep   #$30                     ;16 bit mode
2098 5243 80 0A                 bra   EndLoop
2099 5245
2100 5245 B7 14        Loop     lda   [<TextPtr],y             ;replace chars in selection with chars
2101 5247 97 30                 sta   [<StartPtr],y            ;from scrap
2102 5249 88                    dey   
2103 524A F0 F9                 beq   Loop                     ;in case replace length is odd
2104 524C 88                    dey   
2105 524D 10 F6                 bpl   Loop
2106 524F
2107 524F A5 02        EndLoop  lda   <Remainder               ;get remainder back
2108 5251 F0 26                 beq   Done                     ;remainder is 0 so done
2109 5253 10 05                 bpl   DoInsert                 ;scrap was > selection length
2110 5255 20 CA 51              jsr   DeleteGuts               ;delete remainder of selection
2111 5258 80 1F                 bra   Done
2112 525A
2113 525A 18           DoInsert clc   
2114 525B A5 14                 lda   <TextPtr                 ;create ptr to remainder of text
2115 525D 65 00                 adc   <SelLength               ;which needs to be inserted
2116 525F 85 14                 sta   <TextPtr
2117 5261 A9 00 00              lda   #0
2118 5264 65 16                 adc   <TextPtr+2
2119 5266 85 16                 sta   <TextPtr+2
2120 5268 A5 02                 lda   <Remainder
2121 526A 85 18                 sta   <TextLength
2122 526C
2123 526C 20 7A 52              jsr   InsertGuts               ;insert remaining chars
2124 526F
2125 526F A0 20 00              ldy   #leSelStart
2126 5272 B7 1E                 lda   [<RecPtr],y
2127 5274 A0 22 00              ldy   #leSelEnd                ;set selend equal to selstart
2128 5277 97 1E                 sta   [<RecPtr],y
2129 5279
2130 5279 60           Done     rts   
2131 527A
2132 527A                       EndP 
2133 527A
2134 527A
2135 527A              ****************************************************************
2136 527A              *
2137 527A              * InsertGuts
2138 527A              *
2139 527A              ****************************************************************
2140 527A
2141 527A                       Export InsertGuts 
2142 527A              InsertGuts PROC 
2143 527A
2144 527A              OverFlow equ TempWord1 
2145 527A              MaxLength equ TempWord2 
2146 527A              EndPtr   equ TempPtr1 
2147 527A
2148 527A A5 18                 lda   <TextLength
2149 527C D0 01                 bne   Doit
2150 527E 60                    rts                            ;no text to insert so return
2151 527F
2152 527F A0 06 00     Doit     ldy   #leMaxLength
2153 5282 B7 1E                 lda   [<RecPtr],y              ;get max length of line and save
2154 5284 85 02                 sta   <MaxLength
2155 5286
2156 5286 A0 20 00              ldy   #leSelStart
2157 5289 B7 1E                 lda   [<RecPtr],y              ;get selstart
2158 528B C5 02                 cmp   <MaxLength               ;are we at the max length of the line?
2159 528D 90 01                 bcc   Cont                     ;no
2160 528F 60                    rts                            ;yes - so return
2161 5290
2162 5290 20 04 57     Cont     jsr   CalcStartPtr             ;StartPtr now points to start of sel
2163 5293
2164 5293 18                    clc   
2165 5294 B7 1E                 lda   [<RecPtr],y              ;get selstart
2166 5296 65 18                 adc   <TextLength              ;add insert length
2167 5298 3A                    dec   a
2168 5299 C5 02                 cmp   <MaxLength               ;overflow ?
2169 529B 90 10                 bcc   OK                       ;no
2170 529D 38                    sec                            ;yes - so shorten insert length
2171 529E A5 02                 lda   <MaxLength               ;get max line length
2172 52A0 F7 1E                 sbc   [<RecPtr],y              ;subtract selstart to get
2173 52A2 85 18                 sta   <TextLength              ;max amount to insert
2174 52A4 B7 1E                 lda   [<RecPtr],y              ;get selstart
2175 52A6 A0 04 00              ldy   #leLength
2176 52A9 97 1E                 sta   [<RecPtr],y              ;as save as line length
2177 52AB 80 4E                 bra   EndMove
2178 52AD
2179 52AD A0 04 00     OK       ldy   #leLength
2180 52B0 18                    clc   
2181 52B1 B7 1E                 lda   [<RecPtr],y              ;get length of line and
2182 52B3 65 18                 adc   <TextLength              ;add insert length to determine final
2183 52B5 3A                    dec   a                        ;length of line
2184 52B6 C5 02                 cmp   <MaxLength               ;overflow?
2185 52B8 90 0D                 bcc   OK2                      ;no
2186 52BA 1A                    inc   a
2187 52BB 38                    sec                            ;yes - so
2188 52BC E5 02                 sbc   <MaxLength               ;subtract max length of line to
2189 52BE 85 00                 sta   <Overflow                ;determine amount of overflow
2190 52C0 38                    sec   
2191 52C1 B7 1E                 lda   [<RecPtr],y              ;decrement line length by overflow
2192 52C3 E5 00                 sbc   <Overflow                ;amount so we don't move chars past
2193 52C5 97 1E                 sta   [<RecPtr],y              ;the end of the line
2194 52C7
2195 52C7 B7 1E        OK2      lda   [<RecPtr],y              ;get length of line
2196 52C9 38                    sec   
2197 52CA A0 20 00              ldy   #leSelStart              ;subtract selstart to
2198 52CD F7 1E                 sbc   [<RecPtr],y              ;calculate # chars to move right
2199 52CF F0 2A                 beq   EndMove                  ;branch if no text to move
2200 52D1 A8                    tay                            ;save # chars to move in Y
2201 52D2
2202 52D2 18                    clc                            ;calculate ptr to end of insertion area
2203 52D3 A5 30                 lda   <StartPtr
2204 52D5 65 18                 adc   <TextLength
2205 52D7 85 04                 sta   <EndPtr
2206 52D9 A9 00 00              lda   #0
2207 52DC 65 32                 adc   <StartPtr+2
2208 52DE 85 06                 sta   <EndPtr+2
2209 52E0
2210 52E0 88                    dey                            ;# chars to move
2211 52E1 88                    dey   
2212 52E2 10 0D                 bpl   MoveLoop
2213 52E4 A0 00 00              ldy   #0                       ;only move 1 char
2214 52E7 E2 30                 sep   #$30                     ;8 bit mode
2215 52E9 B7 30                 lda   [<StartPtr],y
2216 52EB 97 04                 sta   [<EndPtr],y
2217 52ED C2 30                 rep   #$30                     ;16 bit mode
2218 52EF 80 0A                 bra   EndMove
2219 52F1
2220 52F1 B7 30        MoveLoop lda   [<StartPtr],y            ;move chars toward end of line to
2221 52F3 97 04                 sta   [<EndPtr],y              ;make room for insertion
2222 52F5 88                    dey   
2223 52F6 F0 F9                 beq   MoveLoop                 ;in case moving odd # of chars
2224 52F8 88                    dey   
2225 52F9 10 F6                 bpl   MoveLoop
2226 52FB
2227 52FB A4 18        EndMove  ldy   <TextLength              ;number of chars to insert
2228 52FD 88                    dey   
2229 52FE 88                    dey   
2230 52FF 10 0D                 bpl   InsLoop
2231 5301 A0 00 00              ldy   #0                       ;insert length = 1
2232 5304 E2 30                 sep   #$30                     ;8 bit mode
2233 5306 B7 14                 lda   [<TextPtr],y
2234 5308 97 30                 sta   [<StartPtr],y
2235 530A C2 30                 rep   #$30                     ;16 bit mode
2236 530C 80 0A                 bra   EndIns
2237 530E
2238 530E B7 14        InsLoop  lda   [<TextPtr],y             ;insert the text
2239 5310 97 30                 sta   [<StartPtr],y
2240 5312 88                    dey   
2241 5313 F0 F9                 beq   InsLoop                  ;in case insert length is odd
2242 5315 88                    dey   
2243 5316 10 F6                 bpl   InsLoop
2244 5318
2245 5318 A0 04 00     EndIns   ldy   #leLength                ;adjust line length by insert amount
2246 531B 20 2E 53              jsr   Adjust
2247 531E
2248 531E A0 20 00              ldy   #leSelStart              ;adjust selstart by insert amount
2249 5321 20 2E 53              jsr   Adjust
2250 5324
2251 5324 A0 22 00              ldy   #leSelEnd                ;adjust selend by insert amount
2252 5327 20 2E 53              jsr   Adjust
2253 532A
2254 532A 20 40 57              jsr   CleanUpSel
2255 532D
2256 532D 60           Done     rts   
2257 532E
2258 532E              ;-------------------------------------------------------------------------------
2259 532E
2260 532E 18           Adjust   clc   
2261 532F B7 1E                 lda   [<RecPtr],y
2262 5331 65 18                 adc   <TextLength
2263 5333 97 1E                 sta   [<RecPtr],y
2264 5335 60                    rts   
2265 5336                       EndP 
2266 5336
2267 5336
2268 5336
2269 5336              ****************************************************************
2270 5336              *
2271 5336              * FindPoint
2272 5336              *
2273 5336              ****************************************************************
2274 5336
2275 5336                       Export FindPoint 
2276 5336              FindPoint PROC 
2277 5336
2278 5336              H1       equ TempWord1 
2279 5336              Diff     equ TempWord2 
2280 5336
2281 5336 F4 00 00              PushWord #0 
2282 5339 F4 00 00 7B           PushZPtr <SelPoint             ;ptr to point where mouse was clicked
2283 5342 18                    clc   
2284 5343 A5 1E                 lda   <RecPtr                  ;create ptr to viewrect field
2285 5345 69 10 00              adc   #leViewRect
2286 5348 AA                    tax   
2287 5349 A5 20                 lda   <RecPtr+2
2288 534B 69 00 00              adc   #0
2289 534E 48                    pha                            ;and push the ptr
2290 534F DA                    phx   
2291 5350 A2 04 4F 22           _PtInRect 
2292 5357 68                    pla                            ;is the point in the viewrect?
2293 5358 D0 02                 bne   InView                   ;yes
2294 535A 38                    sec                            ;no - so set the carry flag
2295 535B 60                    rts                            ;and return
2296 535C
2297 535C              InView    
2298 535C
2299 535C              *
2300 535C              * FindPoint2 entry point always computes <selPoint, as a character
2301 535C              * offset, even if the mouse position is outside the view rectangle.
2302 535C              *
2303 535C              * Added 14-May-91 DAL
2304 535C              *
2305 535C                       export FindPoint2 
2306 535C              FindPoint2  
2307 535C 64 34                 stz   <DispStart
2308 535E A0 04 00              ldy   #leLength
2309 5361 B7 1E                 lda   [<RecPtr],y              ;get length of line
2310 5363 85 36                 sta   <DispEnd
2311 5365 85 18                 sta   <TextLength              ;and save
2312 5367 20 A2 56              jsr   GetSelRect               ;get rect for whole line
2313 536A A5 42                 lda   <SelRect+2
2314 536C 85 00                 sta   <H1                      ;save H1 of selrect
2315 536E
2316 536E A5 3E                 lda   <SelPoint+2              ;get H1 of the point
2317 5370 C5 42                 cmp   <SelRect+2               ;is it less than H1 of selrect?
2318 5372 B0 03                 bcs   CheckR                   ;no - so check against H2
2319 5374 64 3C        clipToLeftEdge stz   <SelPoint          ;yes - so set to first char in line
2320 5376 60                    rts   
2321 5377
2322 5377 C5 46        CheckR   cmp   <SelRect+6               ;is it greater than H2 of selrect?
2323 5379 90 09                 bcc   OnChar                   ;no - so point is on a char
2324 537B A0 04 00     clipToRightEdge ldy   #leLength         ;yes - so set to last char in line
2325 537E B7 1E                 lda   [<RecPtr],y
2326 5380 85 3C                 sta   <SelPoint
2327 5382 18                    clc   
2328 5383 60                    rts   
2329 5384
2330 5384 A0 10 00     OnChar   ldy   #leViewRect
2331 5387 B7 1E                 lda   [<RecPtr],y              ;get V1 of viewrect
2332 5389 85 40                 sta   <SelRect                 ;and save as V1 of selrect
2333 538B A0 14 00              ldy   #leViewRect+4
2334 538E B7 1E                 lda   [<RecPtr],y              ;get V2 of viewrect
2335 5390 85 44                 sta   <SelRect+4               ;and save as V2 of selrect
2336 5392
2337 5392 A9 00 01     Cont     lda   #MaxChars                ;get max possible line length to start
2338 5395 4A           Div2     lsr   a                        ;div by 2
2339 5396 C5 18                 cmp   <TextLength              ;is result <= current line length?
2340 5398 B0 FB                 bcs   Div2                     ;no - so divide by 2 again
2341 539A 85 02                 sta   <Diff                    ;yes - so save
2342 539C
2343 539C              ;do a binary search for which character the mouse point is on
2344 539C
2345 539C 85 18        Loop     sta   <TextLength
2346 539E
2347 539E F4 00 00              PushWord  #0 
2348 53A1 D4 28 D4 26           PushZLong <LinePtr             ;push ptr to text
2349 53A5 D4 18                 PushZWord <TextLength          ;push length to measure
2350 53A7 22 63 56 FC           jsl   MeasureThisText
2351 53AB 18                    clc   
2352 53AC 68                    pla                            ;get width of text
2353 53AD 65 00                 adc   <H1                      ;add to H1
2354 53AF 85 46                 sta   <SelRect+6               ;store in H2
2355 53B1
2356 53B1 F4 00 00              PushWord #0 
2357 53B4 F4 00 00 7B           PushZPtr <SelPoint             ;ptr to point where mouse was clicked
2358 53BD F4 00 00 7B           PushZPtr <SelRect              ;ptr to rect for the text we measured
2359 53C6 A2 04 4F 22           _PtInRect 
2360 53CD 46 02                 lsr   <Diff                    ;divide by 2
2361 53CF F0 0F                 beq   Zero                     ;if 0, then we've found the char
2362 53D1 A5 18                 lda   <TextLength
2363 53D3 FA                    plx                            ;was the point in the rect?
2364 53D4 F0 05                 beq   Add                      ;no - so increase the rect
2365 53D6 38                    sec                            ;yes - so decrease the rect
2366 53D7 E5 02                 sbc   <Diff
2367 53D9 80 C1                 bra   Loop
2368 53DB
2369 53DB 18           Add      clc   
2370 53DC 65 02                 adc   <Diff
2371 53DE 80 BC                 bra   Loop
2372 53E0
2373 53E0              ;now that we know which char the point is on, we need to determine whether it's
2374 53E0              ;on the left or right half of the char so we know which side to put the caret on
2375 53E0
2376 53E0 A3 01        Zero     lda   1,s                      ;check results of last PtInRect call
2377 53E2 F0 02                 beq   NotIn                    ;branch if point wasn't in rect
2378 53E4 C6 18                 dec   <TextLength              ;dec char index
2379 53E6              NotIn     
2380 53E6 F4 00 00              PushWord #0 
2381 53E9 A4 18                 ldy   <TextLength
2382 53EB B7 26                 lda   [<LinePtr],y             ;get char point is on
2383 53ED 29 FF 00              and   #$00FF                   ;mask off hi byte
2384 53F0 48                    pha                            ;and push
2385 53F1 A2 04 A8 22           _CharWidth 
2386 53F8 68                    pla                            ;get width of char
2387 53F9 4A                    lsr   a                        ;divide by 2
2388 53FA
2389 53FA FA                    plx                            ;get result from last PtInRect call
2390 53FB F0 09                 beq   NotIn2                   ;branch if point wasn't in rect
2391 53FD 48                    pha                            ;save 'char width div 2' on stack
2392 53FE 38                    sec   
2393 53FF A5 46                 lda   <SelRect+6               ;get previous H2
2394 5401 E3 01                 sbc   1,s                      ;and subtract 'char width div 2'
2395 5403 FA                    plx                            ;pull 'char width div 2' from stack
2396 5404 80 03                 bra   Cont2
2397 5406
2398 5406 18           NotIn2   clc   
2399 5407 65 46                 adc   <SelRect+6               ;add 'char width div 2' to previous H2
2400 5409 85 46        Cont2    sta   <SelRect+6               ;save new H2
2401 540B F4 00 00              PushWord #0                    ;space for result
2402 540E F4 00 00 7B           PushZPtr <SelPoint 
2403 5417 F4 00 00 7B           PushZPtr <SelRect 
2404 5420 A2 04 4F 22           _PtInRect 
2405 5427 68                    pla                            ;was the point in the rect?
2406 5428 D0 02                 bne   Done                     ;yes - so it's on the L side so done
2407 542A E6 18                 inc   <TextLength              ;no - it's on R side so inc char index
2408 542C A5 18        Done     lda   <TextLength
2409 542E 85 3C                 sta   <SelPoint                ;the caret will go on L of this char
2410 5430 18                    clc   
2411 5431 60                    rts   
2412 5432
2413 5432                       EndP 
2414 5432
2415 5432
2416 5432
2417 5432              ****************************************************************
2418 5432              *
2419 5432              * FindWord
2420 5432              *
2421 5432              ****************************************************************
2422 5432
2423 5432                       Export FindWord 
2424 5432              FindWord PROC 
2425 5432
2426 5432              xLength  equ TempWord1 
2427 5432              ;                                       ;calling routine sets A to char position
2428 5432 AA                    tax                            ;save char position
2429 5433 A0 04 00              ldy   #leLength
2430 5436 B7 1E                 lda   [<RecPtr],y              ;get length of line
2431 5438 85 00                 sta   <xLength                 ;and save
2432 543A
2433 543A 9B                    txy                            ;get position in Y
2434 543B B7 26        LSpaces  lda   [<LinePtr],y             ;read char
2435 543D 29 FF 00              and   #$00FF                   ;mask out hi byte
2436 5440 C9 21 00              cmp   #$21                     ;is char a space or control char?
2437 5443 B0 05                 bcs   LChars                   ;no - so start scanning chars
2438 5445 88                    dey                            ;yes - so move 1 char to left
2439 5446 30 0F                 bmi   LDone                    ;branch if no more chars on left
2440 5448 80 F1                 bra   LSpaces
2441 544A
2442 544A 88           LChars   dey                            ;move 1 char to left
2443 544B 30 0A                 bmi   LDone                    ;branch if no more chars on left
2444 544D B7 26                 lda   [<LinePtr],y             ;read char
2445 544F 29 FF 00              and   #$00FF                   ;mask out hi byte
2446 5452 C9 21 00              cmp   #$21                     ;is char a space or control char?
2447 5455 B0 F3                 bcs   LChars                   ;no - so check next char
2448 5457
2449 5457 C8           LDone    iny                            ;skip the space or control char
2450 5458 84 38                 sty   <WordStart               ;save current position as wordstart
2451 545A
2452 545A 9B                    txy                            ;get back original char position in Y
2453 545B C4 00        RChars   cpy   <xLength                 ;at end of line?
2454 545D F0 1C                 beq   RDone                    ;yes - so quit
2455 545F B7 26                 lda   [<LinePtr],y             ;read char
2456 5461 29 FF 00              and   #$00FF                   ;mask out hi byte
2457 5464 C9 21 00              cmp   #$21                     ;is char a space or control char?
2458 5467 90 03                 bcc   RSpaces                  ;yes - so done scanning chars
2459 5469 C8                    iny                            ;no - so move 1 char to right
2460 546A 80 EF                 bra   RChars                   ;check next char
2461 546C
2462 546C C8           RSpaces  iny                            ;move 1 char to right
2463 546D C4 00                 cpy   <xLength                 ;at end of line?
2464 546F F0 0A                 beq   RDone                    ;yes - so quit
2465 5471 B7 26                 lda   [<LinePtr],y             ;read char
2466 5473 29 FF 00              and   #$00FF                   ;mask out hi byte
2467 5476 C9 21 00              cmp   #$21                     ;is char a space or control char?
2468 5479 90 F1                 bcc   RSpaces                  ;yes - so check next char
2469 547B
2470 547B 84 3A        RDone    sty   <WordEnd                 ;save current position as wordend
2471 547D 60                    rts                            ;done
2472 547E
2473 547E                       EndP 
2474 547E
2475 547E
2476 547E
2477 547E              ****************************************************************
2478 547E              *
2479 547E              * ShowCaret
2480 547E              *
2481 547E              ****************************************************************
2482 547E
2483 547E                       Export ShowCaret 
2484 547E              ShowCaret PROC 
2485 547E
2486 547E A0 24 00              ldy   #leActFlg
2487 5481 B7 1E                 lda   [<RecPtr],y              ;is the edit record active?
2488 5483 F0 1C                 beq   Done                     ;no - so quit
2489 5485
2490 5485 20 22 57              jsr   CmpSel                   ;is selstart = selend?
2491 5488 D0 17                 bne   Done                     ;no - so quit
2492 548A
2493 548A A9 01 00              lda   #1
2494 548D A0 26 00              ldy   #leCarAct
2495 5490 97 1E                 sta   [<RecPtr],y              ;activate caret
2496 5492
2497 5492 A0 28 00              ldy   #leCarOn
2498 5495 B7 1E                 lda   [<RecPtr],y              ;get status of caret
2499 5497 D0 08                 bne   Done                     ;quit if caret already on
2500 5499 A9 01 00              lda   #1
2501 549C 97 1E                 sta   [<RecPtr],y              ;mark caret as on
2502 549E 4C C1 54              jmp   DrawCaret                ;force a redraw
2503 54A1
2504 54A1 60           Done     rts   
2505 54A2
2506 54A2                       EndP 
2507 54A2
2508 54A2
2509 54A2
2510 54A2              ****************************************************************
2511 54A2              *
2512 54A2              * HideCaret
2513 54A2              *
2514 54A2              ****************************************************************
2515 54A2
2516 54A2                       Export HideCaret 
2517 54A2              HideCaret PROC 
2518 54A2
2519 54A2 A0 24 00              ldy   #leActFlg
2520 54A5 B7 1E                 lda   [<RecPtr],y
2521 54A7 F0 17                 beq   Done                     ;quit if edit record not active
2522 54A9
2523 54A9 A0 26 00              ldy   #leCarAct
2524 54AC A9 00 00              lda   #0
2525 54AF 97 1E                 sta   [<RecPtr],y              ;deactivate caret
2526 54B1
2527 54B1 A0 28 00              ldy   #leCarOn
2528 54B4 B7 1E                 lda   [<RecPtr],y
2529 54B6 F0 08                 beq   Done                     ;quit if caret not on
2530 54B8 A9 00 00              lda   #0
2531 54BB 97 1E                 sta   [<RecPtr],y              ;mark caret as off
2532 54BD 4C C1 54              jmp   DrawCaret                ;force a redraw
2533 54C0
2534 54C0 60           Done     rts   
2535 54C1
2536 54C1                       EndP 
2537 54C1
2538 54C1
2539 54C1
2540 54C1              ****************************************************************
2541 54C1              *
2542 54C1              * DrawCaret
2543 54C1              *
2544 54C1              ****************************************************************
2545 54C1
2546 54C1                       Export DrawCaret 
2547 54C1              DrawCaret PROC 
2548 54C1
2549 54C1 A0 20 00              ldy   #leSelStart
2550 54C4 B7 1E                 lda   [<RecPtr],y              ;get selstart
2551 54C6 85 34                 sta   <DispStart               ;and save as dispstart
2552 54C8 85 36                 sta   <DispEnd                 ;and dispend
2553 54CA
2554 54CA 20 A2 56              jsr   GetSelRect               ;get rect with H1 = H2
2555 54CD E6 46                 inc   <SelRect+6               ;increment H2 to make space for caret
2556 54CF A0 34 00              ldy   #leCaretHook+2
2557 54D2 20 F6 54              jsr   InvertHook               ;invert the rect
2558 54D5 60                    rts   
2559 54D6
2560 54D6                       EndP 
2561 54D6
2562 54D6
2563 54D6
2564 54D6              ****************************************************************
2565 54D6              *
2566 54D6              * HiLite
2567 54D6              *
2568 54D6              ****************************************************************
2569 54D6
2570 54D6                       Export HiLite 
2571 54D6              HiLite   PROC 
2572 54D6
2573 54D6 A0 24 00              ldy   #leActFlg
2574 54D9 B7 1E                 lda   [<RecPtr],y
2575 54DB D0 01                 bne   Doit
2576 54DD 60                    rts                            ;quit if edit record not active
2577 54DE
2578 54DE A0 20 00     Doit     ldy   #leSelStart
2579 54E1 B7 1E                 lda   [<RecPtr],y              ;get selstart and save as dispstart
2580 54E3 85 34                 sta   <DispStart
2581 54E5 A0 22 00              ldy   #leSelEnd
2582 54E8 B7 1E                 lda   [<RecPtr],y              ;get selend and save as dispend
2583 54EA 85 36                 sta   <DispEnd
2584 54EC
2585 54EC                       Export HiLite2 
2586 54EC              HiLite2   
2587 54EC 20 A2 56              jsr   GetSelRect               ;get rect from dispstart to dispend
2588 54EF A0 30 00              ldy   #leHiliteHook+2
2589 54F2 20 F6 54              jsr   InvertHook               ;invert the rect
2590 54F5 60                    rts   
2591 54F6
2592 54F6                       EndP 
2593 54F6
2594 54F6
2595 54F6
2596 54F6              ****************************************************************
2597 54F6              *
2598 54F6              * InvertHook
2599 54F6              *
2600 54F6              ****************************************************************
2601 54F6
2602 54F6                       Export InvertHook 
2603 54F6              InvertHook PROC 
2604 54F6
2605 54F6 F4 00 00 7B           PushZPtr <SelRect              ;push ptr to selrect on stack
2606 54FF
2607 54FF B7 1E                 lda   [<RecPtr],y              ;Y was set in calling routine to
2608 5501 88                    dey                            ;#leHiliteHook+2 or #leCaretHook+2
2609 5502 88                    dey   
2610 5503 17 1E                 ora   [<RecPtr],y              ;does hook contain an address?
2611 5505 D0 08                 bne   UseHook                  ;yes - so use it
2612 5507 A2 04 56 22           _InvertRect                    ;no - so use InvertRect
2613 550E 60                    rts   
2614 550F
2615 550F 22 14 55 FC  UseHook  jsl   Kludge                   ;force a long return address on stack
2616 5513 60                    rts                            ;hook routine will RTL here
2617 5514
2618 5514 38           Kludge   sec                            ;push hook address - 1 on stack
2619 5515 B7 1E                 lda   [<RecPtr],y
2620 5517 E9 01 00              sbc   #1
2621 551A AA                    tax   
2622 551B C8                    iny   
2623 551C C8                    iny   
2624 551D B7 1E                 lda   [<RecPtr],y
2625 551F E9 00 00              sbc   #0
2626 5522
2627 5522 E2 20                 sep   #$20                     ;8 bit A
2628 5524 48                    pha                            ;hi byte of hook address
2629 5525 C2 20                 rep   #$20                     ;16 bit A
2630 5527
2631 5527 DA                    phx                            ;lo word of hook address
2632 5528 6B                    rtl                            ;fake a JSL to the hook routine
2633 5529
2634 5529
2635 5529                       EndP 
2636 5529
2637 5529
2638 5529
2639 5529              ****************************************************************
2640 5529              *
2641 5529              * ReDraw
2642 5529              *
2643 5529              ****************************************************************
2644 5529              *
2645 5529              * 11-Mar-91 DAL
2646 5529              *
2647 5529              * Notes on existing code:
2648 5529              *   1. For left-justify, <dispStart must be set up before ReDraw
2649 5529              *      is called.
2650 5529              *   2. DispStart is the character offset of the leftmost character
2651 5529              *      that we have to redraw.
2652 5529              *
2653 5529              ****************************************************************
2654 5529
2655 5529                       Export ReDraw 
2656 5529              ReDraw   PROC 
2657 5529
2658 5529              ;** ReDraw modified 3-6-87 to handle centered and right-justified text. CAE **
2659 5529
2660 5529 A0 36 00              ldy   #leJust
2661 552C B7 1E                 lda   [<RecPtr],y              ;check the text justification
2662 552E F0 02                 beq   ItsLeft                  ;branch if left justified
2663 5530 64 34                 stz   <DispStart               ;zero out DispStart
2664 5532              ItsLeft                                 ;DispStart set up by calling routine
2665 5532
2666 5532 A5 34                 lda   <DispStart               ;want H1 and H2 of SelRect to be the
2667 5534 85 36                 sta   <DispEnd                 ;same
2668 5536
2669 5536 20 A2 56              jsr   GetSelRect
2670 5539
2671 5539 A0 16 00              ldy   #leViewRect+6            ;set H2 of SelRect equal to H2 of the
2672 553C B7 1E                 lda   [<RecPtr],y              ;ViewRect
2673 553E 85 46                 sta   <SelRect+6
2674 5540 F4 00 00 7B           PushZPtr <SelRect              ;push ptr to SelRect
2675 5549 A2 04 55 22           _EraseRect                     ;erase from dispstart to end of viewrect
2676 5550
2677 5550 A0 36 00              ldy   #leJust
2678 5553 B7 1E                 lda   [<RecPtr],y              ;check the text justification again
2679 5555 F0 03                 beq   ItsLeft2                 ;branch if left justified
2680 5557 20 8B 55              jsr   SpecialJust              ;handle centered or right justified
2681 555A              ItsLeft2                                ;
2682 555A
2683 555A A5 42                 lda   <SelRect+2               ;H1
2684 555C 48                    pha   
2685 555D A5 40                 lda   <SelRect                 ;V1 - top of dest rect
2686 555F 18                    clc   
2687 5560 A0 1E 00              ldy   #leBaseHite
2688 5563 77 1E                 adc   [<RecPtr],y              ;calculate base line for text
2689 5565 48                    pha   
2690 5566 A2 04 3A 22           _MoveTo                        ;position pen
2691 556D
2692 556D A0 04 00              ldy   #leLength                ;calculate length of text to draw
2693 5570 B7 1E                 lda   [<RecPtr],y
2694 5572 38                    sec   
2695 5573 E5 34                 sbc   <DispStart
2696 5575 F0 13                 beq   Done                     ;quit if no text to draw
2697 5577 A8                    tay                            ;save length in Y
2698 5578
2699 5578 18                    clc                            ;calculate ptr to text to be drawn
2700 5579 A5 26                 lda   <LinePtr
2701 557B 65 34                 adc   <DispStart
2702 557D AA                    tax   
2703 557E A5 28                 lda   <LinePtr+2
2704 5580 69 00 00              adc   #0
2705 5583 48                    pha                            ;push ptr to text
2706 5584 DA                    phx   
2707 5585 5A                    phy                            ;push length of text
2708 5586
2709 5586 22 06 56 FC           jsl   DrawThisText
2710 558A
2711 558A 60           Done     rts   
2712 558B
2713 558B
2714 558B              ;-------------------------------------------------------------------------------
2715 558B              ;Text is centered or right-justified.
2716 558B
2717 558B 48           SpecialJust pha                         ;save justification for later
2718 558C
2719 558C A0 04 00              ldy   #leLength
2720 558F B7 1E                 lda   [<RecPtr],y              ;get new text length
2721 5591 AA                    tax   
2722 5592
2723 5592 F4 00 00              PushWord #0                    ;space for result
2724 5595 D4 28 D4 26           PushZLong <LinePtr             ;push ptr to line
2725 5599 DA                    phx                            ;push length to measure
2726 559A 22 63 56 FC           jsl   MeasureThisText
2727 559E
2728 559E 38                    sec                            ;calculate width of current DestRect
2729 559F A0 0E 00              ldy   #leDestRect+6            ;which gives us the width of the
2730 55A2 B7 1E                 lda   [<RecPtr],y              ;previous text
2731 55A4 A0 0A 00              ldy   #leDestRect+2
2732 55A7 F7 1E                 sbc   [<RecPtr],y
2733 55A9 C3 01                 cmp   1,s                      ;compare it to width of new text
2734 55AB 90 2A                 bcc   GrowRect
2735 55AD
2736 55AD              ;New text is smaller than previous text so DestRect must shrink.
2737 55AD
2738 55AD E3 01        ShrinkRect sbc   1,s                    ;calculate difference in widths
2739 55AF 83 01                 sta   1,s                      ;and save
2740 55B1
2741 55B1 A3 03                 lda   3,s                      ;check text justification
2742 55B3 30 05                 bmi   Right
2743 55B5 A3 01                 lda   1,s                      ;it's centered so divide width
2744 55B7 4A                    lsr   a                        ;difference by 2
2745 55B8 83 01                 sta   1,s                      ;and save
2746 55BA              Right                                   ;
2747 55BA
2748 55BA 18                    clc                            ;move left side of DestRect to right
2749 55BB A0 0A 00              ldy   #leDestRect+2
2750 55BE B7 1E                 lda   [<RecPtr],y
2751 55C0 63 01                 adc   1,s
2752 55C2 97 1E                 sta   [<RecPtr],y
2753 55C4 85 42                 sta   <SelRect+2
2754 55C6
2755 55C6 A3 03                 lda   3,s                      ;check justification
2756 55C8 30 0A                 bmi   ShrinkDone               ;it's right just - so skip next part
2757 55CA
2758 55CA 38                    sec                            ;move right side of DestRect to left
2759 55CB A0 0E 00              ldy   #leDestRect+6
2760 55CE B7 1E                 lda   [<RecPtr],y
2761 55D0 E3 01                 sbc   1,s
2762 55D2 97 1E                 sta   [<RecPtr],y
2763 55D4
2764 55D4 68           ShrinkDone pla                          ;clean up stack
2765 55D5 68                    pla   
2766 55D6 60                    rts   
2767 55D7
2768 55D7              ;New text is larger than previous text so DestRect must grow.
2769 55D7
2770 55D7 48           GrowRect pha                            ;save width of previous text
2771 55D8 38                    sec   
2772 55D9 A3 03                 lda   3,s
2773 55DB E3 01                 sbc   1,s                      ;calculate difference in widths
2774 55DD 83 03                 sta   3,s                      ;and save
2775 55DF 68                    pla   
2776 55E0
2777 55E0 A3 03                 lda   3,s                      ;check text justification
2778 55E2 30 05                 bmi   Right2
2779 55E4 A3 01                 lda   1,s                      ;it's centered so divide width
2780 55E6 4A                    lsr   a                        ;difference by 2
2781 55E7 83 01                 sta   1,s                      ;and save
2782 55E9              Right2                                  ;
2783 55E9
2784 55E9 38                    sec                            ;move left side of DestRect to left
2785 55EA A0 0A 00              ldy   #leDestRect+2
2786 55ED B7 1E                 lda   [<RecPtr],y
2787 55EF E3 01                 sbc   1,s
2788 55F1 97 1E                 sta   [<RecPtr],y
2789 55F3 85 42                 sta   <SelRect+2
2790 55F5
2791 55F5 A3 03                 lda   3,s                      ;check justification
2792 55F7 30 0A                 bmi   GrowDone                 ;it's right just - so skip next part
2793 55F9
2794 55F9 18                    clc                            ;move right side of DestRect to right
2795 55FA A0 0E 00              ldy   #leDestRect+6
2796 55FD B7 1E                 lda   [<RecPtr],y
2797 55FF 63 01                 adc   1,s
2798 5601 97 1E                 sta   [<RecPtr],y
2799 5603
2800 5603 68           GrowDone pla                            ;clean up stack
2801 5604 68                    pla   
2802 5605 60                    rts   
2803 5606
2804 5606                       EndP 
2805 5606
2806 5606
2807 5606              ****************************************************************
2808 5606              *
2809 5606              DrawThisText PROC 
2810 5606              *
2811 5606              * This routine draws the indicated text or an equal number
2812 5606              * of password characters.
2813 5606              *
2814 5606              * Routine is called with a JSL
2815 5606              *
2816 5606              *
2817 5606              * Inputs:
2818 5606              *                   PtrToText : LONG
2819 5606              *                   TextLength : word
2820 5606              *
2821 5606              * Outputs:
2822 5606              *                   none
2823 5606              *
2824 5606              * External Refs:
2825 5606              *                   none
2826 5606              *
2827 5606              * Entry Points:
2828 5606              *                   none
2829 5606              *
2830 5606                       longa on                       ; mode
2831 5606                       longi on
2832 5606              *
2833 5606              ****************************************************************
2834 5606                       DefineStack 
2835 5606              RtlAddr  block 3 
2836 5606              ThisTextLen word 
2837 5606              ThisTextPtr long 
2838 5606
2839 5606
2840 5606              ;
2841 5606              ; See if programmer wants this treated as password
2842 5606              ;
2843 5606 A0 38 00              ldy   #lePWChar
2844 5609 B7 1E                 lda   [<RecPtr],y
2845 560B D0 08                 bne   ThisIsPassword
2846 560D
2847 560D A2 04 A7              ldx   #$A704                   ; DrawText
2848 5610 22 04 00 E1           jsl   $E10004                  ; THROUGH GLUE ENTRY!
2849 5614 6B                    rtl   
2850 5615
2851 5615
2852 5615              ;
2853 5615              ; This is a password, so draw the pw char only.
2854 5615              ;
2855 5615              ThisIsPassword  
2856 5615
2857 5615 AA                    tax   
2858 5616
2859 5616 A3 04                 lda   ThisTextLen,s
2860 5618 85 60                 sta   MeasureTemp
2861 561A
2862 561A
2863 561A 20 3D 56              jsr   PushCharOnStack
2864 561D
2865 561D 3B                    tsc   
2866 561E 1A                    inc   a
2867 561F F4 00 00              pea   0000
2868 5622 48                    pha   
2869 5623 D4 60                 pei   MeasureTemp
2870 5625 A2 04 A7 22           _DrawText 
2871 562C
2872 562C A5 60                 lda   MeasureTemp
2873 562E 20 50 56              jsr   PullCharOffStack
2874 5631
2875 5631 A3 01                 lda   RTLAddr,s
2876 5633 83 07                 sta   RTLAddr+6,s
2877 5635 A3 02                 lda   RTLAddr+1,s
2878 5637 83 08                 sta   RTLAddr+1+6,s
2879 5639
2880 5639 68                    pla   
2881 563A 68                    pla   
2882 563B 68                    pla   
2883 563C
2884 563C 6B                    rtl   
2885 563D
2886 563D                       ENTRY PushCharOnStack
2887 563D              PushCharOnStack  
2888 563D C9 00 00              cmp   #0
2889 5640 D0 01                 bne   @NotZero
2890 5642 60                    rts   
2891 5643              @NotZero  
2892 5643 A8                    tay                            ; put length in y
2893 5644 8A                    txa                            ; put char in a-reg
2894 5645 FA                    plx                            ; pull off rts addr
2895 5646
2896 5646 E2 20                 sep   #$20                     ; 8 bit a-reg
2897 5648                       longa off
2898 5648
2899 5648 48           @PushLoop pha                           ; push these on stack
2900 5649 88                    dey   
2901 564A D0 FC                 bne   @PushLoop
2902 564C
2903 564C C2 20                 rep   #$20
2904 564E                       longa on
2905 564E
2906 564E DA                    phx   
2907 564F 60                    rts   
2908 5650
2909 5650
2910 5650                       ENTRY PullCharOffStack
2911 5650              PullCharOffStack  
2912 5650 C9 00 00              cmp   #0
2913 5653 D0 01                 bne   @NotZero
2914 5655 60                    rts   
2915 5656              @NotZero  
2916 5656 A8                    tay                            ; put length in y
2917 5657 8A                    txa                            ; put char in a-reg
2918 5658 FA                    plx                            ; pull off rts addr
2919 5659
2920 5659 E2 20                 sep   #$20                     ; 8 bit a-reg
2921 565B                       longa off
2922 565B
2923 565B 68           @PushLoop pla                           ; push these on stack
2924 565C 88                    dey   
2925 565D D0 FC                 bne   @PushLoop
2926 565F
2927 565F C2 20                 rep   #$20
2928 5661                       longa on
2929 5661
2930 5661 DA                    phx   
2931 5662 60                    rts   
2932 5663
2933 5663
2934 5663
2935 5663                       EndP 
2936 5663
2937 5663              ****************************************************************
2938 5663              *
2939 5663              MeasureThisText PROC 
2940 5663              *
2941 5663              * This routine measures the indicated text or an equal number
2942 5663              * of password characters.
2943 5663              *
2944 5663              * Routine is called with a JSL
2945 5663              *
2946 5663              *
2947 5663              * Inputs:
2948 5663              *                   Space for result : word
2949 5663              *                   PtrToText : LONG
2950 5663              *                   TextLength : word
2951 5663              *
2952 5663              * Outputs:
2953 5663              *                   Pixels wide : word
2954 5663              *
2955 5663              * External Refs:
2956 5663              *                   none
2957 5663              *
2958 5663              * Entry Points:
2959 5663              *                   none
2960 5663              *
2961 5663                       longa on                       ; mode
2962 5663                       longi on
2963 5663              *
2964 5663              ****************************************************************
2965 5663                       DefineStack 
2966 5663              RtlAddr  block 3 
2967 5663              ThisTextLen word 
2968 5663              ThisTextPtr long 
2969 5663              ThisTextWidth word 
2970 5663
2971 5663
2972 5663              ;
2973 5663              ; See if programmer wants this treated as password
2974 5663              ;
2975 5663 A0 38 00              ldy   #lePWChar
2976 5666 B7 1E                 lda   [<RecPtr],y
2977 5668 D0 08                 bne   ThisIsPassword
2978 566A
2979 566A A2 04 AB              ldx   #$AB04                   ; TextWidth
2980 566D 22 04 00 E1           jsl   $E10004                  ; through GLUE ENTRY!
2981 5671 6B                    rtl   
2982 5672
2983 5672
2984 5672              ;
2985 5672              ; This is a password, so draw the pw char only.
2986 5672              ;
2987 5672 AA           ThisIsPassword tax   
2988 5673
2989 5673 A3 04                 lda   ThisTextLen,s
2990 5675 85 60                 sta   MeasureTemp
2991 5677
2992 5677 20 3D 56              jsr   PushCharOnStack
2993 567A
2994 567A 3B                    tsc   
2995 567B 1A                    inc   a
2996 567C 48                    pha   
2997 567D F4 00 00              pea   0000
2998 5680 48                    pha   
2999 5681 D4 60                 pei   MeasureTemp
3000 5683 A2 04 AB 22           _TextWidth 
3001 568A
3002 568A A5 60                 lda   MeasureTemp
3003 568C FA                    plx   
3004 568D 86 60                 stx   MeasureTemp
3005 568F
3006 568F 20 50 56              jsr   PullCharOffStack
3007 5692
3008 5692 A5 60                 lda   MeasureTemp
3009 5694 83 0A                 sta   ThisTextWidth,s
3010 5696
3011 5696 A3 01                 lda   RTLAddr,s
3012 5698 83 07                 sta   RTLAddr+6,s
3013 569A A3 02                 lda   RTLAddr+1,s
3014 569C 83 08                 sta   RTLAddr+1+6,s
3015 569E
3016 569E 68                    pla   
3017 569F 68                    pla   
3018 56A0 68                    pla   
3019 56A1
3020 56A1 6B                    rtl   
3021 56A2
3022 56A2
3023 56A2                       EndP 
3024 56A2
3025 56A2
3026 56A2
3027 56A2              ****************************************************************
3028 56A2              *
3029 56A2              * GetSelRect
3030 56A2              *
3031 56A2              ****************************************************************
3032 56A2
3033 56A2                       Export GetSelRect 
3034 56A2              GetSelRect PROC 
3035 56A2
3036 56A2              ;calculate rect from dispstart to dispend and save in SelRect
3037 56A2
3038 56A2 A5 34                 lda   <DispStart
3039 56A4 C5 36                 cmp   <DispEnd                 ;is dispstart < dispend?
3040 56A6 90 06                 bcc   OK                       ;yes
3041 56A8 A6 36                 ldx   <DispEnd                 ;no - so swap them
3042 56AA 85 36                 sta   <DispEnd
3043 56AC 86 34                 stx   <DispStart
3044 56AE
3045 56AE A0 08 00     OK       ldy   #leDestRect
3046 56B1 B7 1E                 lda   [<RecPtr],y              ;get V1 of destrect
3047 56B3 85 40                 sta   <SelRect                 ;and save as V1 of selrect
3048 56B5 A0 1C 00              ldy   #leLineHite
3049 56B8 18                    clc   
3050 56B9 77 1E                 adc   [<RecPtr],y              ;then add linehite to V1
3051 56BB 85 44                 sta   <SelRect+4               ;and save as V2 of selrect
3052 56BD A0 0A 00              ldy   #leDestRect+2
3053 56C0 B7 1E                 lda   [<RecPtr],y              ;get H1 of destrect
3054 56C2 85 42                 sta   <SelRect+2               ;and save as H1 of selrect
3055 56C4
3056 56C4 A5 34                 lda   <DispStart               ;if dispstart is 0, skip next section
3057 56C6 F0 13                 beq   Cont
3058 56C8
3059 56C8 F4 00 00              PushWord #0                    ;space for result
3060 56CB D4 28 D4 26           PushZLong <LinePtr             ;push ptr to line
3061 56CF D4 34                 PushZWord <DispStart           ;push length to measure
3062 56D1 22 63 56 FC           jsl   MeasureThisText          ;measure from start of line to dispstart
3063 56D5 68                    pla                            ;get text width
3064 56D6 18                    clc   
3065 56D7 65 42                 adc   <SelRect+2               ;add H1 of destrect
3066 56D9 85 42                 sta   <SelRect+2               ;and save as H1 of selrect
3067 56DB
3068 56DB A5 36        Cont     lda   <DispEnd
3069 56DD C5 34                 cmp   <DispStart               ;dispend = dispstart?
3070 56DF D0 04                 bne   Cont1                    ;no - so measure
3071 56E1 A5 42                 lda   <SelRect+2               ;yes - so set H2 to H1
3072 56E3 80 14                 bra   Done
3073 56E5
3074 56E5 F4 00 00     Cont1    PushWord #0                    ;space for result
3075 56E8 D4 28 D4 26           PushZLong <LinePtr             ;push ptr to line
3076 56EC D4 36                 PushZWord <DispEnd             ;push length to measure
3077 56EE 22 63 56 FC           jsl   MeasureThisText          ;measure from start of line to dispend
3078 56F2 68                    pla                            ;get text width
3079 56F3 A0 0A 00              ldy   #leDestRect+2
3080 56F6 18                    clc   
3081 56F7 77 1E                 adc   [<RecPtr],y              ;add H1 of destrect
3082 56F9 85 46        Done     sta   <SelRect+6               ;and save as H2 of selrect
3083 56FB 60                    rts   
3084 56FC
3085 56FC                       EndP 
3086 56FC
3087 56FC
3088 56FC              ****************************************************************
3089 56FC              *
3090 56FC              * SaveStartProc
3091 56FC              *
3092 56FC              ****************************************************************
3093 56FC
3094 56FC                       Export SaveStartProc 
3095 56FC              SaveStartProc PROC 
3096 56FC
3097 56FC A0 20 00              ldy   #leSelStart
3098 56FF B7 1E                 lda   [<RecPtr],y              ;get selstart and save as
3099 5701 85 34                 sta   <DispStart               ;dispstart (will be used by ReDraw)
3100 5703 60                    rts   
3101 5704
3102 5704                       EndP 
3103 5704
3104 5704
3105 5704              ****************************************************************
3106 5704              *
3107 5704              * CalcStartPtr
3108 5704              *
3109 5704              ****************************************************************
3110 5704
3111 5704                       Export CalcStartPtr 
3112 5704              CalcStartPtr PROC 
3113 5704
3114 5704 18                    clc   
3115 5705 A0 20 00              ldy   #leSelStart
3116 5708 B7 1E                 lda   [<RecPtr],y              ;get selstart
3117 570A 65 26                 adc   <LinePtr                 ;calculate ptr to start of selection
3118 570C 85 30                 sta   <StartPtr                ;and save in StartPtr
3119 570E A9 00 00              lda   #0
3120 5711 65 28                 adc   <LinePtr+2
3121 5713 85 32                 sta   <StartPtr+2
3122 5715 60                    rts                            ;return with Y = leSelStart
3123 5716
3124 5716                       EndP 
3125 5716
3126 5716
3127 5716              ****************************************************************
3128 5716              *
3129 5716              * CalcSelLen
3130 5716              *
3131 5716              ****************************************************************
3132 5716
3133 5716                       Export CalcSelLen 
3134 5716              CalcSelLen PROC 
3135 5716
3136 5716 A0 22 00              ldy   #leSelEnd                ;calculate length of selection range
3137 5719 B7 1E                 lda   [<RecPtr],y
3138 571B 38                    sec   
3139 571C A0 20 00              ldy   #leSelStart
3140 571F F7 1E                 sbc   [<RecPtr],y
3141 5721 60                    rts                            ;return length in A
3142 5722
3143 5722                       EndP 
3144 5722
3145 5722
3146 5722              ****************************************************************
3147 5722              *
3148 5722              * CmpSel
3149 5722              *
3150 5722              ****************************************************************
3151 5722
3152 5722                       Export CmpSel 
3153 5722              CmpSel   PROC 
3154 5722
3155 5722 A0 22 00              ldy   #leSelEnd
3156 5725 B7 1E                 lda   [<RecPtr],y
3157 5727 A0 20 00              ldy   #leSelStart
3158 572A D7 1E                 cmp   [<RecPtr],y              ;compare selstart and selend and
3159 572C 60                    rts                            ;return with Y = leSelStart
3160 572D
3161 572D                       EndP 
3162 572D
3163 572D
3164 572D              ****************************************************************
3165 572D              *
3166 572D              * SelSort
3167 572D              *
3168 572D              ****************************************************************
3169 572D
3170 572D                       Export SelSort 
3171 572D              SelSort  PROC 
3172 572D 20 22 57              jsr   CmpSel                   ;is selend >= selstart?
3173 5730 B0 0D                 bcs   OK                       ;yes - so OK
3174 5732 AA                    tax                            ;no - so swap them,  save selend in X
3175 5733 B7 1E                 lda   [<RecPtr],y              ;get selstart and push on stack
3176 5735 48                    pha   
3177 5736 8A                    txa                            ;get selend back in A
3178 5737 97 1E                 sta   [<RecPtr],y              ;and save in selstart
3179 5739 A0 22 00              ldy   #leSelEnd
3180 573C 68                    pla                            ;get selstart off stack
3181 573D 97 1E                 sta   [<RecPtr],y              ;and save in selend
3182 573F 60           OK       rts   
3183 5740
3184 5740                       EndP 
3185 5740
3186 5740
3187 5740              ****************************************************************
3188 5740              *
3189 5740              * CleanUpSel
3190 5740              *
3191 5740              ****************************************************************
3192 5740
3193 5740                       Export CleanUpSel 
3194 5740              CleanUpSel PROC 
3195 5740
3196 5740 A0 04 00              ldy   #leLength
3197 5743 B7 1E                 lda   [<RecPtr],y              ;get line length
3198 5745 A0 22 00              ldy   #leSelEnd
3199 5748 D7 1E                 cmp   [<RecPtr],y              ;is length >= selend ?
3200 574A B0 02                 bcs   EndOK                    ;yes
3201 574C 97 1E                 sta   [<RecPtr],y              ;no - so set selend to length
3202 574E
3203 574E B7 1E        EndOK    lda   [<RecPtr],y              ;get selend
3204 5750 A0 20 00              ldy   #leSelStart
3205 5753 D7 1E                 cmp   [<RecPtr],y              ;is selend >= selstart ?
3206 5755 B0 02                 bcs   StartOK                  ;yes
3207 5757 97 1E                 sta   [<RecPtr],y              ;no - so set selstart to selend
3208 5759
3209 5759 60           StartOK  rts   
3210 575A
3211 575A                       EndP 
3212 575A
3213 575A
3214 575A              ****************************************************************
3215 575A              *
3216 575A              * StdEnd
3217 575A              *
3218 575A              ****************************************************************
3219 575A
3220 575A                       Export StdEnd 
3221 575A              StdEnd   PROC 
3222 575A A4 5E                 ldy   <StripSize               ;# bytes of param to strip
3223 575C 5C B0 FC FE           jml   EndCall
3224 5760                       EndP 
3225 5760
3226 5760
3227 5760              ****************************************************************
3228 5760              *
3229 5760              * StdErr
3230 5760              *
3231 5760              ****************************************************************
3232 5760
3233 5760                       Export StdErr 
3234 5760              StdErr   PROC 
3235 5760 A4 5E                 ldy   <StripSize               ;# bytes of param to strip
3236 5762 5C B3 FC FE           jml   ErrOut
3237 5766                       EndP 
3238 5766
3239 5766
3240 5766              ****************************************************************
3241 5766              *
3242 5766              * oStdEnd0
3243 5766              *
3244 5766              ****************************************************************
3245 5766
3246 5766                       Export oStdEnd0 
3247 5766              oStdEnd0 PROC 
3248 5766 A0 00 00              ldy   #0                       ;# bytes of param to strip
3249 5769 5C ED FC FE           jml   oEndCall
3250 576D                       EndP 
3251 576D
3252 576D
3253 576D              ****************************************************************
3254 576D              *
3255 576D              * StdEnd0
3256 576D              *
3257 576D              ****************************************************************
3258 576D
3259 576D                       Export StdEnd0 
3260 576D              StdEnd0  PROC 
3261 576D A0 00 00              ldy   #0                       ;# bytes of param to strip
3262 5770 5C B0 FC FE           jml   EndCall
3263 5774                       EndP 
3264 5774
3265 5774
3266 5774              ****************************************************************
3267 5774              *
3268 5774              * StdErr0
3269 5774              *
3270 5774              ****************************************************************
3271 5774
3272 5774                       Export StdErr0 
3273 5774              StdErr0  PROC 
3274 5774 A0 00 00              ldy   #0                       ;# bytes of param to strip
3275 5777 5C B3 FC FE           jml   ErrOut
3276 577B                       EndP 
3277 577B
3278 577B
3279 577B              ****************************************************************
3280 577B              *
3281 577B              * StdEnd4
3282 577B              *
3283 577B              ****************************************************************
3284 577B
3285 577B                       Export StdEnd4 
3286 577B              StdEnd4  PROC 
3287 577B A0 04 00              ldy   #4                       ;# bytes of param to strip
3288 577E 5C B0 FC FE           jml   EndCall
3289 5782                       EndP 
3290 5782
3291 5782
3292 5782              ****************************************************************
3293 5782              *
3294 5782              * StdErr4
3295 5782              *
3296 5782              ****************************************************************
3297 5782
3298 5782                       Export StdErr4 
3299 5782              StdErr4  PROC 
3300 5782 A0 04 00              ldy   #4                       ;# bytes of param to strip
3301 5785 5C B3 FC FE           jml   ErrOut
3302 5789                       EndP 
3303 5789
3304 5789
3305 5789              ****************************************************************
3306 5789              *
3307 5789              * StdEntry
3308 5789              *
3309 5789              ****************************************************************
3310 5789
3311 5789                       Export StdEntry 
3312 5789              StdEntry PROC 
3313 5789
3314 5789 A3 0B                 lda   11,s                     ;get rec handle
3315 578B 85 1A                 sta   <RecHandle
3316 578D A3 0D                 lda   13,s
3317 578F 85 1C                 sta   <RecHandle+2
3318 5791
3319 5791                       Export StdEntry2 
3320 5791              StdEntry2  
3321 5791
3322 5791 86 5E                 stx   <StripSize               ;save # bytes of param to strip later
3323 5793 64 54                 stz   <ErrFlag                 ;clear error count
3324 5795
3325 5795 20 6C 58              jsr   LockRec                  ;lock rec handle and convert to ptr
3326 5798 20 8D 58              jsr   LockLine                 ;lock line handle and convert to ptr
3327 579B
3328 579B F4 00 00 F4           PushLong #0 
3329 57A1 A2 04 1C 22           _GetPort                       ;get current port
3330 57A8 68                    pla                            ;and save
3331 57A9 85 0C                 sta   <SavePort
3332 57AB 68                    pla   
3333 57AC 85 0E                 sta   <SavePort+2
3334 57AE
3335 57AE A0 1A 00              ldy   #lePort+2                ;set to our port
3336 57B1 B7 1E                 lda   [<RecPtr],y
3337 57B3 48                    pha   
3338 57B4 88                    dey   
3339 57B5 88                    dey   
3340 57B6 B7 1E                 lda   [<RecPtr],y
3341 57B8 48                    pha   
3342 57B9 A2 04 1B 22           _SetPort 
3343 57C0
3344 57C0 F4 00 00 F4           PushLong #0 
3345 57C6 A2 04 67 22           _NewRgn                        ;make room for clip info
3346 57CD 90 08                 bcc   OK
3347 57CF FA                    plx                            ;pull result
3348 57D0 FA                    plx   
3349 57D1 48                    pha                            ;save error code on stack
3350 57D2 E6 54                 inc   <ErrFlag                 ;inc error count
3351 57D4 4C 4E 58              jmp   CExit                    ;clean up
3352 57D7
3353 57D7 A3 01        OK       lda   1,s
3354 57D9 85 10                 sta   <SaveClip
3355 57DB A3 03                 lda   3,s
3356 57DD 85 12                 sta   <SaveClip+2
3357 57DF A2 04 25 22           _GetClip                       ;save current clip
3358 57E6 90 06                 bcc   OK2
3359 57E8 48                    pha                            ;save error code on stack
3360 57E9 E6 54                 inc   <ErrFlag                 ;inc error count
3361 57EB 4C 3E 58              jmp   BExit                    ;clean up
3362 57EE
3363 57EE 18           OK2      clc                            ;push ptr to viewrect
3364 57EF A5 1E                 lda   <RecPtr
3365 57F1 69 10 00              adc   #leViewRect
3366 57F4 AA                    tax   
3367 57F5 A5 20                 lda   <RecPtr+2
3368 57F7 69 00 00              adc   #0
3369 57FA 48                    pha   
3370 57FB DA                    phx   
3371 57FC A2 04 26 22           _ClipRect                      ;set clip to viewrect
3372 5803 B0 20                 bcs   GotErr
3373 5805
3374 5805 D4 12 D4 10           PushZLong <SaveClip            ;push saved clip
3375 5809
3376 5809 F4 00 00 F4           PushLong #0 
3377 580F A2 04 C7 22           _GetClipHandle                 ;get our clip - leave on stack
3378 5816
3379 5816 A3 03                 lda   3,s                      ;our clip will be destination also
3380 5818 48                    pha   
3381 5819 A3 03                 lda   3,s
3382 581B 48                    pha   
3383 581C A2 04 71 22           _SectRgn                       ;intersect saved clip and our clip
3384 5823 90 06                 bcc   Done
3385 5825 48           GotErr   pha                            ;save error code on stack
3386 5826 E6 54                 inc   <ErrFlag                 ;inc error count
3387 5828 4C 2E 58              jmp   AExit                    ;clean up
3388 582B
3389 582B 60           Done     rts   
3390 582C
3391 582C                       EndP 
3392 582C
3393 582C
3394 582C
3395 582C              ****************************************************************
3396 582C              *
3397 582C              * StdExit
3398 582C              *
3399 582C              ****************************************************************
3400 582C
3401 582C                       Export StdExit 
3402 582C              StdExit  PROC 
3403 582C
3404 582C 64 54                 stz   <ErrFlag                 ;clear error count
3405 582E
3406 582E                       Export AExit 
3407 582E              AExit     
3408 582E D4 12 D4 10           PushZLong <SaveClip 
3409 5832 A2 04 24 22           _SetClip                       ;restore original clip
3410 5839 90 03                 bcc   BExit
3411 583B 48                    pha                            ;save error code on stack
3412 583C E6 54                 inc   <ErrFlag                 ;inc error count
3413 583E
3414 583E                       Export BExit 
3415 583E              BExit     
3416 583E D4 12 D4 10           PushZLong <SaveClip 
3417 5842 A2 04 68 22           _DisposeRgn                    ;dispose of our copy of original clip
3418 5849 90 03                 bcc   CExit
3419 584B 48                    pha                            ;save error code on stack
3420 584C E6 54                 inc   <ErrFlag                 ;inc error count
3421 584E
3422 584E                       Export CExit 
3423 584E              CExit     
3424 584E D4 0E D4 0C           PushZLong <SavePort 
3425 5852 A2 04 1B 22           _SetPort                       ;restore original port
3426 5859
3427 5859 20 AE 58              jsr   UnLockLine
3428 585C 20 82 58              jsr   UnLockRec
3429 585F
3430 585F A5 54                 lda   <ErrFlag                 ;check error count
3431 5861 D0 01                 bne   GotErr                   ;got an error
3432 5863 60                    rts                            ;no error so return
3433 5864
3434 5864 FA           GotErr   plx                            ;pull error code off stack
3435 5865 3A                    dec   a                        ;dec error count
3436 5866 D0 FC                 bne   GotErr                   ;branch if more error codes on stack
3437 5868
3438 5868 68                    pla                            ;pull return address off stack
3439 5869 4C 60 57              jmp   StdErr                   ;return the error
3440 586C
3441 586C                       EndP 
3442 586C
3443 586C
3444 586C              ****************************************************************
3445 586C              *
3446 586C              * LockRec
3447 586C              *
3448 586C              ****************************************************************
3449 586C
3450 586C                       Export LockRec 
3451 586C              LockRec  PROC 
3452 586C
3453 586C A0 04 00              ldy   #4
3454 586F B7 1A                 lda   [<RecHandle],y
3455 5871 09 00 80              ora   #$8000                   ;set locked bit in attribute word
3456 5874 97 1A                 sta   [<RecHandle],y
3457 5876 A0 02 00              ldy   #2
3458 5879 A7 1A                 lda   [<RecHandle]             ;dereference handle
3459 587B 85 1E                 sta   <RecPtr
3460 587D B7 1A                 lda   [<RecHandle],y
3461 587F 85 20                 sta   <RecPtr+2
3462 5881 60                    rts   
3463 5882
3464 5882                       EndP 
3465 5882
3466 5882
3467 5882              ****************************************************************
3468 5882              *
3469 5882              * UnLockRec
3470 5882              *
3471 5882              ****************************************************************
3472 5882
3473 5882                       Export UnLockRec 
3474 5882              UnLockRec PROC 
3475 5882
3476 5882 A0 04 00              ldy   #4
3477 5885 B7 1A                 lda   [<RecHandle],y
3478 5887 29 FF 7F              and   #$7FFF                   ;clear locked bit in attribute word
3479 588A 97 1A                 sta   [<RecHandle],y
3480 588C 60                    rts   
3481 588D
3482 588D                       EndP 
3483 588D
3484 588D
3485 588D              ****************************************************************
3486 588D              *
3487 588D              * LockLine
3488 588D              *
3489 588D              ****************************************************************
3490 588D
3491 588D                       Export LockLine 
3492 588D              LockLine PROC 
3493 588D
3494 588D A7 1E                 lda   [<RecPtr]
3495 588F 85 22                 sta   <LineHandle
3496 5891 A0 02 00              ldy   #2
3497 5894 B7 1E                 lda   [<RecPtr],y
3498 5896 85 24                 sta   <LineHandle+2
3499 5898
3500 5898                       Export LockLine2 
3501 5898              LockLine2  
3502 5898 A0 04 00              ldy   #4
3503 589B B7 22                 lda   [<LineHandle],y
3504 589D 09 00 80              ora   #$8000                   ;set locked bit in attribute word
3505 58A0 97 22                 sta   [<LineHandle],y
3506 58A2 A0 02 00              ldy   #2
3507 58A5 A7 22                 lda   [<LineHandle]            ;dereference handle
3508 58A7 85 26                 sta   <LinePtr
3509 58A9 B7 22                 lda   [<LineHandle],y
3510 58AB 85 28                 sta   <LinePtr+2
3511 58AD 60                    rts   
3512 58AE
3513 58AE                       EndP 
3514 58AE
3515 58AE
3516 58AE              ****************************************************************
3517 58AE              *
3518 58AE              * UnLockLine
3519 58AE              *
3520 58AE              ****************************************************************
3521 58AE
3522 58AE                       Export UnLockLine 
3523 58AE              UnLockLine PROC 
3524 58AE
3525 58AE A0 04 00              ldy   #4
3526 58B1 B7 22                 lda   [<LineHandle],y
3527 58B3 29 FF 7F              and   #$7FFF                   ;clear locked bit in attribute word
3528 58B6 97 22                 sta   [<LineHandle],y
3529 58B8 60                    rts   
3530 58B9
3531 58B9                       EndP 
3532 58B9
3533 58B9
3534 58B9              ****************************************************************
3535 58B9              *
3536 58B9              * LockScrap
3537 58B9              *
3538 58B9              ****************************************************************
3539 58B9
3540 58B9                       Export LockScrap 
3541 58B9              LockScrap PROC 
3542 58B9
3543 58B9 A0 04 00              ldy   #4
3544 58BC B7 2A                 lda   [<ScrapHandle],y
3545 58BE 09 00 80              ora   #$8000                   ;set locked bit in attribute word
3546 58C1 97 2A                 sta   [<ScrapHandle],y
3547 58C3 A0 02 00              ldy   #2
3548 58C6 A7 2A                 lda   [<ScrapHandle]           ;dereference handle
3549 58C8 85 14                 sta   <TextPtr
3550 58CA B7 2A                 lda   [<ScrapHandle],y
3551 58CC 85 16                 sta   <TextPtr+2
3552 58CE 60                    rts   
3553 58CF
3554 58CF                       EndP 
3555 58CF
3556 58CF
3557 58CF              ****************************************************************
3558 58CF              *
3559 58CF              * UnLockScrap
3560 58CF              *
3561 58CF              ****************************************************************
3562 58CF
3563 58CF                       Export UnLockScrap 
3564 58CF              UnLockScrap PROC 
3565 58CF
3566 58CF A0 04 00              ldy   #4
3567 58D2 B7 2A                 lda   [<ScrapHandle],y
3568 58D4 29 FF 7F              and   #$7FFF                   ;clear locked bit in attribute word
3569 58D7 97 2A                 sta   [<ScrapHandle],y
3570 58D9 60                    rts   
3571 58DA                       EndP 
3572 58DA
3573 58DA
3574 58DA                       PRINT PUSH 
3575 58DA                       PRINT NOWARN 
3576 58DA              ****************************************************************
3577 58DA              *
3578 58DA              * LETextBox2
3579 58DA              *
3580 58DA              *
3581 58DA              * Change History
3582 58DA              *
3583 58DA              * 05 Aug 88         STeven Glass
3584 58DA              *
3585 58DA              * If bounding box was bad, we just exit, but check was made
3586 58DA              * after handle allocated.  We move the check up and this
3587 58DA              * should make prevent the orphaning of the handle.
3588 58DA              *
3589 58DA              * The error code was not preserved through the code that
3590 58DA              * restores the grafport.
3591 58DA              *
3592 58DA              ****************************************************************
3593 58DA
3594 58DA                       Export LETextBox2 
3595 58DA              LETextBox2 PROC                         ;** modified 4-22-87 CAE **
3596 58DA
3597 58DA              ;-----------------------------------------------------------
3598 58DA              ;
3599 58DA              ; DirectPage
3600 58DA              ;
3601 58DA              ;-----------------------------------------------------------
3602 58DA              MyId     equ 92 
3603 58DA
3604 58DA              LastPartChar equ 96 
3605 58DA              LastFullChar equ LastPartChar+2 
3606 58DA              ClipRgn  equ LastFullChar+2 
3607 58DA              LEZero   equ ClipRgn+4 
3608 58DA              LastLeading equ LEZero+2 
3609 58DA              MaxLine  equ LastLeading+2 
3610 58DA              TempPtr  equ MaxLine+2 
3611 58DA              TempTP   equ TempPtr+4 
3612 58DA              TempTL   equ TempTp+4 
3613 58DA              Change   equ TempTL+2 
3614 58DA              Skiping  equ Change+2 
3615 58DA              changeflg equ Skiping+2 
3616 58DA              TextRgn  equ changeflg+2 
3617 58DA              BoxRgn   equ TextRgn+4 
3618 58DA              FontInfoPtr equ BoxRgn+4 
3619 58DA              FontInfoRec equ FontInfoPtr+4 
3620 58DA              FontGlobals equ FontInfoRec+8 
3621 58DA              Spaces   equ FontGlobals+4 
3622 58DA              CurrentSpaces equ Spaces+2 
3623 58DA              TokenLength equ CurrentSpaces+2 
3624 58DA              MaxWidth equ TokenLength+2 
3625 58DA              CharLine equ MaxWidth+2 
3626 58DA              CurrentWidth equ CharLine+2 
3627 58DA              Temp     equ CurrentWidth+2 
3628 58DA              Tabs     equ Temp+2 
3629 58DA              Nothing  equ Tabs+2 
3630 58DA              TERec    equ Nothing+2 
3631 58DA              TERuler  equ TERec+4 
3632 58DA              LineStyle equ TERuler+2 
3633 58DA              FGHandle equ LineStyle+2 
3634 58DA              LineRuler equ FGHandle+4 
3635 58DA              Char     equ LineRuler+4 
3636 58DA              OffSet   equ Char+2 
3637 58DA              InputDone equ Offset+2 
3638 58DA              LineDone equ InputDone+2 
3639 58DA              MaxHeight equ LineDone+2 
3640 58DA              CurrentHeight equ MaxHeight+2 
3641 58DA              CRFlag   equ CurrentHeight+2 
3642 58DA              OrigDirect equ CRFlag+2 
3643 58DA              RTL1     equ OrigDirect+2 
3644 58DA              RTL2     equ RTL1+3 
3645 58DA              TextJust equ RTL2+3 
3646 58DA              TextRectPtr equ TextJust+2 
3647 58DA              TextLen  equ TextRectPtr+4 
3648 58DA              TextPtr  equ TextLen+2 
3649 58DA              GotFChange equ TextPtr+4 
3650 58DA
3651 58DA              ;--------------------------------------------------------------------
3652 58DA              ;
3653 58DA              ; TERecord
3654 58DA              ;
3655 58DA              ;--------------------------------------------------------------------
3656 58DA              TEPtr    equ 0 
3657 58DA              TELen    equ TEPtr+4 
3658 58DA              DestRect equ TELen+2 
3659 58DA              ViewRect equ DestRect+4 
3660 58DA              SelRect  equ ViewRect+4 
3661 58DA              SelPoint equ SelRect+4 
3662 58DA              SelStart equ SelPoint+4 
3663 58DA              SelEnd   equ SelStart+2 
3664 58DA              InPort   equ SelEnd+2 
3665 58DA              ClickTime equ InPort+4 
3666 58DA              ClickLoc equ ClickTime+4 
3667 58DA              caretTime equ ClickLoc+2 
3668 58DA              CaretState equ ClickTime+4 
3669 58DA              RecalBack equ CaretState+2 
3670 58DA              RecalLines equ RecalBack+2 
3671 58DA              ClickStuff equ RecalLines+2 
3672 58DA              ClickLoop equ ClickStuff+2 
3673 58DA              WordBreak equ ClickLoop+4 
3674 58DA              HighHook equ WordBreak+4 
3675 58DA              CaretHook equ HighHook+4 
3676 58DA              TabHook  equ CaretHook+4 
3677 58DA              AutoIndent equ TabHook+4 
3678 58DA              NLines   equ AutoIndent+4 
3679 58DA              LSPTR    equ NLines+2 
3680 58DA              LHPtr    equ LSPtr+4 
3681 58DA
3682 58DA              ;TERuler
3683 58DA              FGroundColor equ 0 
3684 58DA              BGroundColor equ FGroundColor+2 
3685 58DA              FamNum   equ BGroundColor+2 
3686 58DA              SizeStyle equ FamNum+2 
3687 58DA              Just     equ SizeStyle+2 
3688 58DA              CROnly   equ Just+2 
3689 58DA              LeftMargin equ CROnly+2 
3690 58DA              RightMargin equ LeftMargin+2 
3691 58DA              ExtraSpacing equ RightMargin+2 
3692 58DA              EQTemperedLS equ ExtraSpacing+2         ;Q change not fully implemented!
3693 58DA              SInvis   equ EQTemperedLS+2 
3694 58DA              NextRuler equ SInvis+2 
3695 58DA
3696 58DA              ;--------------------------------------------------------------------
3697 58DA              ;Data
3698 58DA
3699 58DA              DeltaFlg equ $01 
3700 58DA              S        equ $53 
3701 58DA              F        equ $46 
3702 58DA              Z        equ $5A 
3703 58DA              B        equ $42 
3704 58DA              C        equ $43 
3705 58DA              J        equ $4A 
3706 58DA              L        equ $4C 
3707 58DA              M        equ $4D 
3708 58DA              R        equ $52 
3709 58DA              X        equ $58 
3710 58DA              Q        equ $51 
3711 58DA
3712 58DA
3713 58DA              ; Overlay my parameters with the direct page
3714 58DA 0B                    phd                            ;save direct page
3715 58DB 5B                    tcd                            ;set the direct page
3716 58DC              ;I now have storage for variables and a new direct page
3717 58DC
3718 58DC 68                    pla   
3719 58DD 85 C6                 sta   OrigDirect
3720 58DF 68                    pla   
3721 58E0 85 C8                 sta   rtl1
3722 58E2 68                    pla   
3723 58E3 85 CA                 sta   rtl1+2
3724 58E5 68                    pla   
3725 58E6 85 CC                 sta   rtl1+4
3726 58E8 68                    pla   
3727 58E9 85 CE                 sta   TextJust
3728 58EB 68                    pla   
3729 58EC 85 D0                 sta   TextRectPtr
3730 58EE 68                    pla   
3731 58EF 85 D2                 sta   TextRectPtr+2
3732 58F1 68                    pla   
3733 58F2 85 D4                 sta   TextLen
3734 58F4 68                    pla   
3735 58F5 85 D6                 sta   TextPtr
3736 58F7 68                    pla   
3737 58F8 85 D8                 sta   TextPtr+2
3738 58FA
3739 58FA
3740 58FA              ;-----------------------------------------------------------
3741 58FA              ;
3742 58FA              ; Now that stack is cleaned off I must save parts of the 
3743 58FA              ; grafPort that may be changed.
3744 58FA              ;
3745 58FA 8B                    phb                            ; save the dbr
3746 58FB 48                    pha                            ; get current port ptr
3747 58FC 48                    pha   
3748 58FD A2 04 1C 22           _GetPort 
3749 5904 A3 02                 lda   2,s                      ; set dbr to bank of port
3750 5906 48                    pha   
3751 5907 AB                    plb   
3752 5908 AB                    plb   
3753 5909 FA                    plx                            ; put ptr in x
3754 590A 68                    pla                            ; ignore high word
3755 590B A0 1A 00              ldy   #opicSave-ofontHandle-2  ; use this as count
3756 590E BD 74 00     @1       lda   |ofontHandle,x           ; read the words from the grafport
3757 5911 48                    pha                            ; and put them on the stack
3758 5912 E8                    inx   
3759 5913 E8                    inx   
3760 5914 88                    dey   
3761 5915 88                    dey   
3762 5916 10 F6                 bpl   @1                       ; repeat until y < 0
3763 5918
3764 5918
3765 5918
3766 5918              ;---------------------------------------------------------------
3767 5918              ;
3768 5918              ; LegalRect
3769 5918              ;
3770 5918              ; Quit's Textbox if passed an illegal rect.
3771 5918              ;
3772 5918              ; Moved this code in front of code that does new handle
3773 5918              ; so when it exits, there is not handle to dispose.
3774 5918              ;
3775 5918 A7 D0                 lda   [TextRectPtr]
3776 591A A0 04 00              ldy   #4
3777 591D D7 D0                 cmp   [TextRectPtr],y
3778 591F 10 0C                 bpl   aBadRect
3779 5921 A0 02 00              ldy   #2
3780 5924 B7 D0                 lda   [TextRectPtr],y
3781 5926 A0 06 00              ldy   #6
3782 5929 D7 D0                 cmp   [TextRectPtr],y
3783 592B 30 03                 bmi   RectOK
3784 592D 82 71 02     aBadRect brl   Exit                     ;It's illegal so quit.
3785 5930
3786 5930              RectOK    
3787 5930
3788 5930              ;--------------------------------------------------------------
3789 5930              ;
3790 5930              ;TENew
3791 5930              ;
3792 5930              ;Get a new handle or memory for the TERecord, and set it up.
3793 5930              ;
3794 5930              TENew     
3795 5930 F4 00 00 F4           PushLong #0 
3796 5936 F4 00 00 F4           PushLong #NextRuler+NextRuler 
3797 593C A5 5C                 lda   MyId                     ;Use this as myid
3798 593E 48                    pha   
3799 593F F4 00 C0              PushWord #$C000                ;changed to Locked HY 5/5/88
3800 5942 F4 00 00 F4           PushLong #0 
3801 5948 A2 02 09 22           _NewHandle                     ;get new handle
3802 594F 90 04                 bcc   newH
3803 5951 48                    pha                            ;push error code
3804 5952 82 4B 02              brl   cleanUpstack             ;clean things up
3805 5955 68           newH     pla   
3806 5956 85 A8                 sta   TERec                    ;get TEREC handle
3807 5958 68                    pla   
3808 5959 85 AA                 sta   TERec+2
3809 595B
3810 595B A5 AA                 lda   TERec+2
3811 595D 48                    pha   
3812 595E A5 A8                 lda   TERec
3813 5960 48                    pha   
3814 5961 20 DA 5B              jsr   Deref
3815 5964 68                    pla   
3816 5965 85 B4                 sta   LineRuler
3817 5967 68                    pla   
3818 5968 85 B6                 sta   LineRuler+2
3819 596A
3820 596A
3821 596A              ;====================================================================
3822 596A              ;
3823 596A              ;Actual routine
3824 596A              ;
3825 596A              ;setup
3826 596A              ;mainloop
3827 596A              ;cleanup
3828 596A
3829 596A              ;---------------------------------------------------------------
3830 596A              ;SetUp
3831 596A              ;
3832 596A
3833 596A              SetUp     
3834 596A
3835 596A              ;Get a NewRgn to be set to the ClipRgn
3836 596A
3837 596A F4 00 00 F4           PushLong #0 
3838 5970 A2 04 67 22           _NewRgn 
3839 5977 68                    pla   
3840 5978 85 64                 sta   ClipRgn
3841 597A 68                    pla   
3842 597B 85 66                 sta   ClipRgn+2
3843 597D 90 04                 bcc   GetCLip                  ;if no error continue
3844 597F 48                    pha                            ;save error code
3845 5980 82 10 02              brl   Handle1                  ;got an error.
3846 5983 A5 66        GetClip  lda   ClipRgn+2
3847 5985 48                    pha   
3848 5986 A5 64                 lda   ClipRgn
3849 5988 48                    pha   
3850 5989 A2 04 25 22           _GetClip 
3851 5990 90 04                 bcc   GetTextRgn               ;if no error continue
3852 5992 48                    pha                            ;save error code
3853 5993 82 F0 01              brl   ErrorClip                ;got an error.
3854 5996
3855 5996              ;Get a NewRgn to be set to the TextRect area
3856 5996
3857 5996 F4 00 00 F4  GetTextRgn PushLong #0 
3858 599C A2 04 67 22           _NewRgn 
3859 59A3 68                    pla   
3860 59A4 85 7E                 sta   TextRgn
3861 59A6 68                    pla   
3862 59A7 85 80                 sta   TextRgn+2
3863 59A9 90 04                 bcc   RectRgn                  ;if no error continue
3864 59AB 48                    pha                            ;save error code
3865 59AC 82 D7 01              brl   ErrorClip                ;got an error.
3866 59AF A5 80        RectRgn  lda   TextRgn+2
3867 59B1 48                    pha   
3868 59B2 A5 7E                 lda   TextRgn
3869 59B4 48                    pha   
3870 59B5 A5 D2                 lda   TextRectPtr+2
3871 59B7 48                    pha   
3872 59B8 A5 D0                 lda   TextRectPtr
3873 59BA 48                    pha   
3874 59BB A2 04 6C 22           _RectRgn 
3875 59C2 90 04                 bcc   GetBoxRgn                ;if no error continue
3876 59C4 48                    pha                            ;save error code
3877 59C5 82 B1 01              brl   ErrorText                ;got an error.
3878 59C8
3879 59C8              ;Get a NewRgn for intersection of TextRgn and old clipping.
3880 59C8
3881 59C8 F4 00 00 F4  GetBoxRgn PushLong #0 
3882 59CE A2 04 67 22           _NewRgn 
3883 59D5 68                    pla   
3884 59D6 85 82                 sta   BoxRgn
3885 59D8 68                    pla   
3886 59D9 85 84                 sta   BoxRgn+2
3887 59DB 90 04                 bcc   SectRgn                  ;if no error continue
3888 59DD 48                    pha                            ;save error code
3889 59DE 82 98 01              brl   ErrorText                ;got an error.
3890 59E1 A5 66        SectRgn  lda   ClipRgn+2
3891 59E3 48                    pha   
3892 59E4 A5 64                 lda   ClipRgn
3893 59E6 48                    pha   
3894 59E7 A5 80                 lda   TextRgn+2
3895 59E9 48                    pha   
3896 59EA A5 7E                 lda   TextRgn
3897 59EC 48                    pha   
3898 59ED A5 84                 lda   BoxRgn+2
3899 59EF 48                    pha   
3900 59F0 A5 82                 lda   BoxRgn
3901 59F2 48                    pha   
3902 59F3 A2 04 71 22           _SectRgn 
3903 59FA 90 04                 bcc   SetClip                  ;if no error continue
3904 59FC 48                    pha                            ;save error code
3905 59FD 82 6C 01              brl   ErrorBox                 ;got an error.
3906 5A00
3907 5A00              ;Reset the clipping to my new clipping area.
3908 5A00
3909 5A00 A5 84        SetClip  lda   BoxRgn+2
3910 5A02 48                    pha   
3911 5A03 A5 82                 lda   BoxRgn
3912 5A05 48                    pha   
3913 5A06 A2 04 24 22           _SetClip 
3914 5A0D 90 04                 bcc   EraseRect                ;if no error continue
3915 5A0F 48                    pha                            ;save error code
3916 5A10 82 59 01              brl   ErrorBox                 ;got an error.
3917 5A13
3918 5A13              ;First do an EraseRect on the TextRectPtr area.
3919 5A13
3920 5A13 A5 D2        EraseRect lda   TextRectPtr+2
3921 5A15 48                    pha   
3922 5A16 A5 D0                 lda   TextRectPtr
3923 5A18 48                    pha   
3924 5A19 A2 04 55 22           _EraseRect 
3925 5A20
3926 5A20              ;Calculate the FontHeight
3927 5A20              ;Using TextRgn to as FontInfoPtr until I get the font Hieght
3928 5A20
3929 5A20 7B                    tdc                            ;transfer direct page to accumulator.
3930 5A21 18                    clc   
3931 5A22 69 8A 00              adc   #FontInfoRec             ;add offset to record.
3932 5A25 64 88                 stz   FontInfoPtr+2            ;It's on directPage.
3933 5A27 85 86                 sta   FontInfoPtr              ;Store address.
3934 5A29 A5 88                 lda   FontInfoPtr+2            ;pass pointer
3935 5A2B 48                    pha   
3936 5A2C A5 86                 lda   FontInfoPtr
3937 5A2E 48                    pha   
3938 5A2F A2 04 96 22           _GetFontInfo                   ;get the font info
3939 5A36
3940 5A36              ;Move the pen to the correct position.
3941 5A36 A0 02 00              ldy   #2
3942 5A39 B7 D0                 lda   [TextRectPtr],y
3943 5A3B 48                    pha                            ;pass horizontal = to rect.
3944 5A3C A7 D0                 lda   [TextRectPtr]            ;Get the top.
3945 5A3E A0 02 00              ldy   #2
3946 5A41 38                    sec   
3947 5A42 F7 86                 sbc   [fontInfoPtr],y          ;subtract descent.
3948 5A44 85 C2                 sta   CurrentHeight            ;current vertical position
3949 5A46 48                    pha                            ;pass the vetical.
3950 5A47 A2 04 3A 22           _MoveTo 
3951 5A4E
3952 5A4E 64 9E                 stz   CharLine
3953 5A50 A9 01 00              lda   #1
3954 5A53 85 C4                 sta   CRFlag
3955 5A55
3956 5A55              ;------------------------------------------------------------------------
3957 5A55              ;
3958 5A55              ;SavePort
3959 5A55              ;
3960 5A55
3961 5A55 F4 00 00              PushWord #0 
3962 5A58 F4 00 00              PushWord #0 
3963 5A5B F4 00 00              PushWord #0 
3964 5A5E F4 00 00              PushWord #0 
3965 5A61 A2 04 CF 22           _GetFGSize 
3966 5A68 A5 5C                 lda   MyId
3967 5A6A 48                    pha   
3968 5A6B F4 00 00              PushWord #0 
3969 5A6E F4 00 00 F4           PushLong #0 
3970 5A74 A2 02 09 22           _NewHandle 
3971 5A7B 90 04                 bcc   H5A81
3972 5A7D 48                    pha   
3973 5A7E 82 DE 00              brl   CleanUp
3974 5A81 68           H5A81    pla   
3975 5A82 85 B0                 sta   FGHandle
3976 5A84 68                    pla   
3977 5A85 85 B2                 sta   FGHandle+2
3978 5A87 A5 B2                 lda   FGHandle+2
3979 5A89 48                    pha   
3980 5A8A A5 B0                 lda   FGHandle
3981 5A8C 48                    pha   
3982 5A8D 20 DA 5B              jsr   DeRef
3983 5A90 68                    pla   
3984 5A91 85 92                 sta   FontGlobals
3985 5A93 68                    pla   
3986 5A94 85 94                 sta   FontGlobals+2
3987 5A96 A5 94                 lda   FontGlobals+2
3988 5A98 48                    pha   
3989 5A99 A5 92                 lda   FontGlobals
3990 5A9B 48                    pha   
3991 5A9C A2 04 97 22           _GetFontGlobals 
3992 5AA3 A7 92                 lda   [FontGlobals]
3993 5AA5
3994 5AA5              ;Save Font Family Number
3995 5AA5 A0 04 00              ldy   #FamNum
3996 5AA8 97 B4                 sta   [LineRuler],y
3997 5AAA A0 1A 00              ldy   #FamNum+NextRuler
3998 5AAD 97 B4                 sta   [LineRuler],y
3999 5AAF
4000 5AAF              ;Save Font Size/Style
4001 5AAF A0 04 00              ldy   #FamNum                  ;get size
4002 5AB2 B7 92                 lda   [FontGlobals],y
4003 5AB4 29 FF 00              and   #$00FF                   ;mask off hi byte
4004 5AB7 EB                    xba                            ;put size in hi byte
4005 5AB8 48                    pha                            ;and save
4006 5AB9 A0 02 00              ldy   #2                       ;get style
4007 5ABC B7 92                 lda   [FontGlobals],y
4008 5ABE 29 FF 00              and   #$00FF                   ;mask off hi byte
4009 5AC1 03 01                 ora   1,s                      ;OR with size
4010 5AC3 FA                    plx                            ;clean up stack
4011 5AC4 A0 06 00              ldy   #SizeStyle
4012 5AC7 97 B4                 sta   [LineRuler],y
4013 5AC9 A0 1C 00              ldy   #SizeStyle+NextRuler
4014 5ACC 97 B4                 sta   [LineRuler],y
4015 5ACE
4016 5ACE              ;Save Color
4017 5ACE 48                    pha                            ;space for result
4018 5ACF A2 04 A3 22           _GetBackColor 
4019 5AD6 A0 18 00              ldy   #NextRuler+BGroundColor
4020 5AD9 68                    pla                            ;get index
4021 5ADA 97 B4                 sta   [LineRuler],y            ;save background color
4022 5ADC
4023 5ADC 48                    pha                            ;space for result
4024 5ADD A2 04 A1 22           _GetForeColor 
4025 5AE4 A0 16 00              ldy   #NextRuler+FGroundColor
4026 5AE7 68                    pla                            ;get index
4027 5AE8 97 B4                 sta   [LineRuler],y            ;save background color
4028 5AEA
4029 5AEA A9 00 00              lda   #0
4030 5AED A0 0C 00              ldy   #LeftMargin
4031 5AF0 97 B4                 sta   [LineRuler],y
4032 5AF2 A0 0E 00              ldy   #RightMargin
4033 5AF5 97 B4                 sta   [LineRuler],y
4034 5AF7 A0 12 00              ldy   #EQTemperedLS
4035 5AFA 97 B4                 sta   [LineRuler],y
4036 5AFC
4037 5AFC              ;zero Extra spacing
4038 5AFC A0 10 00              ldy   #ExtraSpacing
4039 5AFF 97 B4                 sta   [LineRuler],y
4040 5B01 64 62                 stz   LastFullChar
4041 5B03 64 60                 stz   LastPartChar
4042 5B05 64 6C                 stz   MaxLine
4043 5B07
4044 5B07 20 0C 5C              jsr   GetMaxWidth
4045 5B0A
4046 5B0A
4047 5B0A              ;=========================================================================
4048 5B0A              ;
4049 5B0A              ;MainLoop
4050 5B0A              ;
4051 5B0A
4052 5B0A 22 F0 5B FC  MainLoop jsl   ResetVariables           ;varibles for each new line.
4053 5B0E 22 47 5C FC           jsl   GetALine                 ;GetALine to print.
4054 5B12
4055 5B12 A0 12 00              ldy   #EQTemperedLS
4056 5B15 B7 B4                 lda   [LineRuler],y
4057 5B17 D0 03                 bne   @prline
4058 5B19 20 4D 5E              jsr   NewLine                  ;reset pen.
4059 5B1C
4060 5B1C              @prline   
4061 5B1C 22 A8 5C FC           jsl   OutputLine               ;Print that line.
4062 5B20
4063 5B20 A5 C4                 lda   CRFlag                   ;get crFlag.
4064 5B22 F0 06                 beq   @NoCr                    ;if not a cr, don't count it.
4065 5B24 A9 01 00              lda   #1                       ;Amount to bump.
4066 5B27 20 26 5C              jsr   BumpTextPtr              ;Bump the TextPtr.
4067 5B2A              @noCR     
4068 5B2A
4069 5B2A              ;Loop Until InputDone or TextLen <= 0 or VPos > RectBottom + Height
4070 5B2A
4071 5B2A A5 BC                 lda   InputDone                ;Get InputDone.
4072 5B2C D0 0D                 bne   MLExit                   ;Exit if InputDone.
4073 5B2E A0 04 00              ldy   #4                       ;Get offset to Bottom.
4074 5B31 B7 D0                 lda   [TextRectPtr],y          ;Get Bottom.
4075 5B33 C5 C2                 cmp   CurrentHeight            ;Compare with Current V Pos.
4076 5B35 30 04                 bmi   MLExit                   ;If out of view Exit.
4077 5B37 A5 D4                 lda   TextLen                  ;Get TextLen.
4078 5B39 D0 CF                 bne   MainLoop                 ;if still has text don't quit.
4079 5B3B
4080 5B3B              MLExit    
4081 5B3B A0 12 00              ldy   #EQTemperedLS
4082 5B3E B7 B4                 lda   [LineRuler],y
4083 5B40 F0 0A                 beq   quit
4084 5B42 A5 72                 lda   TempTP
4085 5B44 85 D6                 sta   TextPtr
4086 5B46 A5 76                 lda   TempTL
4087 5B48 85 D4                 sta   TextLen
4088 5B4A 80 BE                 bra   MainLoop
4089 5B4C
4090 5B4C 20 73 60     quit     jsr   ResetPort                ;put port back to how it was.
4091 5B4F
4092 5B4F              ;------------------------------------------------------------------
4093 5B4F              ;
4094 5B4F              ;End of Main Loop
4095 5B4F              ;
4096 5B4F
4097 5B4F
4098 5B4F              ;--------------------------------------------------------------------
4099 5B4F              ;
4100 5B4F              ;Clean up stuff
4101 5B4F              ;
4102 5B4F
4103 5B4F F4 00 00              pea   0                        ;clear error code.
4104 5B52
4105 5B52 A5 B2 48 A5           PushLong FGHandle 
4106 5B58 A2 02 10 22           _DisposeHandle 
4107 5B5F
4108 5B5F              Cleanup   
4109 5B5F A5 66 48 A5           PushLong ClipRgn 
4110 5B65 A2 04 24 22           _SetClip 
4111 5B6C A5 84 48 A5  ErrorBox PushLong BoxRgn 
4112 5B72 A2 04 68 22           _DisposeRgn 
4113 5B79 A5 80 48 A5  ErrorText PushLong TextRgn 
4114 5B7F A2 04 68 22           _DisposeRgn 
4115 5B86 A5 66 48 A5  ErrorClip PushLong ClipRgn 
4116 5B8C A2 04 68 22           _DisposeRgn 
4117 5B93
4118 5B93 A5 AA 48 A5  Handle1  PushLong TERec                 ;get rid of TERec handle
4119 5B99 A2 02 10 22           _DisposeHandle 
4120 5BA0
4121 5BA0 FA           CleanUpStack plx                        ;get the error code into x.
4122 5BA1
4123 5BA1              Exit      
4124 5BA1              ;-----------------------------------------------------------
4125 5BA1              ;
4126 5BA1              ; Now take grafport fields off the stack and put back into
4127 5BA1              ; the port. 
4128 5BA1              ;
4129 5BA1 86 A2                 stx   Temp                     ; save error code in temp
4130 5BA3
4131 5BA3 48                    pha                            ; get current port ptr
4132 5BA4 48                    pha   
4133 5BA5 A2 04 1C 22           _GetPort 
4134 5BAC A3 02                 lda   2,s                      ; set dbr to bank of port
4135 5BAE 48                    pha   
4136 5BAF AB                    plb   
4137 5BB0 AB                    plb   
4138 5BB1 FA                    plx                            ; put ptr in x
4139 5BB2 68                    pla                            ; ignore high word
4140 5BB3 A0 1A 00              ldy   #opicSave-ofontHandle-2  ; use this as count
4141 5BB6 68           @1       pla                            ; get word off stack and write into port
4142 5BB7 9D 8E 00              sta   |opicSave-2,x
4143 5BBA CA                    dex   
4144 5BBB CA                    dex   
4145 5BBC 88                    dey   
4146 5BBD 88                    dey   
4147 5BBE 10 F6                 bpl   @1                       ; repeat until y < 0
4148 5BC0
4149 5BC0 AB                    plb                            ; restore dbr
4150 5BC1
4151 5BC1 A6 A2                 ldx   Temp                     ; get error code (if any) back.
4152 5BC3
4153 5BC3 A5 CC                 lda   rtl2+1
4154 5BC5 48                    pha   
4155 5BC6 A5 CA 48 A5           PushLong rtl1 
4156 5BCC A5 C6                 lda   OrigDirect
4157 5BCE 5B                    tcd                            ;reset direct page
4158 5BCF 8A                    txa                            ;get error code in a
4159 5BD0 C9 01 00              cmp   #1                       ;set c bit occordingly
4160 5BD3 6B                    rtl   
4161 5BD4
4162 5BD4              ;---------------------------------------------------------------------
4163 5BD4              ;
4164 5BD4              ;GetOffset
4165 5BD4              ;
4166 5BD4              ;Adds CharLine and TokenLength and leaves it in the accumulator.
4167 5BD4              ;
4168 5BD4 A5 9E        GetOffset lda   CharLine                ;get charline
4169 5BD6 18                    clc   
4170 5BD7 65 9A                 adc   TokenLength              ;add the tokenLength to it.
4171 5BD9 60                    rts   
4172 5BDA
4173 5BDA              ;-----------------------------------------------------------------------
4174 5BDA              ;
4175 5BDA              ;Deref
4176 5BDA              ;
4177 5BDA              ;Derefrences the handle, or pointer on the stack and puts it back on the
4178 5BDA              ;Stack.  Uses TempPtr as temporary storage for pointer.
4179 5BDA              ;
4180 5BDA 68           Deref    pla   
4181 5BDB 85 A2                 sta   Temp                     ;get return address.
4182 5BDD 68                    pla                            ;get low word
4183 5BDE 85 6E                 sta   TempPtr                  ;save in FontInfoPtr
4184 5BE0 68                    pla                            ;get High word
4185 5BE1 85 70                 sta   TempPtr+2                ;save in FontInfoPtr
4186 5BE3 A0 02 00              ldy   #2
4187 5BE6 B7 6E                 lda   [TempPtr],y
4188 5BE8 48                    pha   
4189 5BE9 A7 6E                 lda   [TempPtr]                ;deref to low word
4190 5BEB 48                    pha                            ;put on stack
4191 5BEC A5 A2                 lda   Temp                     ;Push return address
4192 5BEE 48                    pha   
4193 5BEF 60                    rts   
4194 5BF0
4195 5BF0              ;----------------------------------------------------------------------------
4196 5BF0              ;
4197 5BF0              ;ResetVariables
4198 5BF0              ;
4199 5BF0
4200 5BF0 A0 06 00     ResetVariables ldy   #6
4201 5BF3 B7 86                 lda   [FontInfoPtr],y
4202 5BF5 85 6A                 sta   LastLeading
4203 5BF7 64 9A                 stz   TokenLength
4204 5BF9 64 98                 stz   CurrentSpaces
4205 5BFB 64 A4                 stz   Tabs
4206 5BFD 64 A0                 stz   CurrentWidth
4207 5BFF 64 96                 stz   Spaces
4208 5C01 64 9E                 stz   CharLine
4209 5C03 64 C0                 stz   MaxHeight
4210 5C05 64 78                 stz   Change
4211 5C07 64 7C                 stz   ChangeFlg
4212 5C09 64 DA                 stz   GotFChange
4213 5C0B 6B                    rtl   
4214 5C0C
4215 5C0C              ;------------------------------------------------------------------
4216 5C0C              ;
4217 5C0C              ; Get the MaxWidth
4218 5C0C              ;
4219 5C0C A0 06 00     GetMaxWidth ldy   #6
4220 5C0F B7 D0                 lda   [TextRectPtr],y          ;get right most pixel
4221 5C11 A0 02 00              ldy   #2
4222 5C14 38                    sec   
4223 5C15 F7 D0                 sbc   [TextRectPtr],y          ;sub left most pixel
4224 5C17 A0 0C 00              ldy   #LeftMargin
4225 5C1A 38                    sec   
4226 5C1B F7 B4                 sbc   [LineRuler],y
4227 5C1D A0 0E 00              ldy   #RightMargin
4228 5C20 38                    sec   
4229 5C21 F7 B4                 sbc   [LineRuler],y
4230 5C23 85 9C                 sta   MaxWidth                 ;save result as MaxWidth
4231 5C25 60                    rts   
4232 5C26
4233 5C26
4234 5C26              ;==================================================================
4235 5C26              ;
4236 5C26              ;MainLoop Routines
4237 5C26              ;
4238 5C26
4239 5C26              ;-------------------------------------------------------------
4240 5C26              ;Uses Flags: CRFlag init 1; LineDone loc GetALine dep MaxWidth; InputDone init 0
4241 5C26              ;         Nothing.
4242 5C26              ;
4243 5C26
4244 5C26
4245 5C26              ;------------------------------------------------------------------
4246 5C26              ;BumpTextPtr (Bump)
4247 5C26              ;
4248 5C26
4249 5C26 85 A2        BumpTextPtr sta   Temp                  ;Save the bump.
4250 5C28 A5 60                 lda   LastPartChar
4251 5C2A 85 62                 sta   LastFullChar
4252 5C2C 18                    clc   
4253 5C2D 65 A2                 adc   Temp
4254 5C2F 85 60                 sta   LastPartChar
4255 5C31 A5 A2                 lda   Temp                     ;Save the Bump.
4256 5C33 18                    clc   
4257 5C34 65 D6                 adc   TextPtr                  ;and add the Bump to it.
4258 5C36 85 D6                 sta   TextPtr
4259 5C38 A5 D8                 lda   TextPtr+2                ;bump the high word
4260 5C3A 69 00 00              adc   #0                       ;and add the Bump to it.
4261 5C3D 85 D8                 sta   TextPtr+2
4262 5C3F A5 D4                 lda   TextLen                  ;get the Length.
4263 5C41 38                    sec   
4264 5C42 E5 A2                 sbc   Temp
4265 5C44 85 D4                 sta   TextLen
4266 5C46 60                    rts                            ;finished
4267 5C47
4268 5C47
4269 5C47              ;---------------------------------------------------------------------
4270 5C47              ;
4271 5C47              ;GetALine
4272 5C47              ;1. Gets A line to be Drawn
4273 5C47              ;2. No Leading Blanks, unless needed because of (LeftJ or FillJ) and CRFlag.
4274 5C47              ;3. No Traling Blanks.
4275 5C47              ;4. Returns CharLine which is # of Char to be drawn from TextPtr.
4276 5C47              ;5. Will do 4 above even if it has to break a word to fit.
4277 5C47              ;
4278 5C47              ;
4279 5C47
4280 5C47 20 35 60     GetALine jsr   UpdateHeight
4281 5C4A E6 A6                 inc   Nothing                  ;Set Nothing to True.
4282 5C4C 64 BE                 stz   LineDone                 ;Set LineDoen to False.
4283 5C4E 64 BC                 stz   InputDone                ;set input done to False.
4284 5C50
4285 5C50              ;The following lines have been commented out so that leading blanks are stripped
4286 5C50              ;correctly when the previous line was left or fill justified and this line will
4287 5C50              ;be right or center justified.   5-8-87 CAE
4288 5C50
4289 5C50              ;              lda      CRFlag                 ;Get CRFlag.
4290 5C50              ;              beq      SkpngBlanks            ;if not CRFlag then go to loop.
4291 5C50              ;              lda      TextJust               ;get TextJustification.
4292 5C50              ;              beq      GALRepeat              ;if left just don't skip blanks.
4293 5C50              ;              cmp      #2                     ;compare just with fill.
4294 5C50              ;              beq      GALRepeat              ;if fill then don't skip blanks.
4295 5C50
4296 5C50 E6 7A        SkpngBlanks inc   Skiping
4297 5C52 20 81 5E              jsr   ScanBlanks               ;ScanBlanks at Begining of line.
4298 5C55 A5 C4                 lda   CRFlag
4299 5C57 F0 09                 beq   Skip
4300 5C59 A5 CE                 lda   TextJust                 ;get TextJustification.
4301 5C5B F0 13                 beq   GALRepeat                ;if left just don't skip blanks.
4302 5C5D C9 02 00              cmp   #2                       ;compare just with fill.
4303 5C60 F0 0E                 beq   GALRepeat                ;if fill then don't skip blanks.
4304 5C62              Skip                                    ;
4305 5C62 20 D4 5B              jsr   GetOffset                ;get # of Spaces to skip.
4306 5C65 20 26 5C              jsr   BumpTextPtr              ;Bump text ptr passed blanks.
4307 5C68 64 9E                 stz   CharLine
4308 5C6A 64 9A                 stz   TokenLength              ;zero the variables used...
4309 5C6C 64 A4                 stz   Tabs                     ;...to get the blanks.
4310 5C6E 64 96                 stz   Spaces
4311 5C70 64 7A        GALRepeat stz   Skiping
4312 5C72 20 81 5E              jsr   ScanBlanks               ;calculate blanks.
4313 5C75 20 A1 5E              jsr   ScanToken                ;get a token.
4314 5C78 20 CB 60              jsr   CheckDone                ;set lineDone if I'm done.
4315 5C7B A5 BC                 lda   InputDone                ;if input done then quit.
4316 5C7D D0 28                 bne   GALExit                  ;else continue normally.
4317 5C7F A5 BE                 lda   LineDone                 ;get LineDone.
4318 5C81 F0 09                 beq   NotDone                  ;Keep going if not done.
4319 5C83 64 BC                 stz   Inputdone                ;else don't quit completly.
4320 5C85 A5 A6                 lda   Nothing                  ;Get nothing.
4321 5C87 F0 03                 beq   NotDone                  ;if Nothing false keep going.
4322 5C89 20 0C 61              jsr   BrkToken                 ;Have only one token, brk it.
4323 5C8C A4 9E        NotDone  ldy   CharLine                 ;get offset to first char.
4324 5C8E B7 D6                 lda   [TextPtr],y              ;get char.
4325 5C90 29 FF 00              and   #$00FF                   ;get only one char.
4326 5C93 C9 0D 00              cmp   #$0d                     ;see if it's a CR.
4327 5C96 D0 03                 bne   NotACR                   ;if not a cr then branch.
4328 5C98 E6 C4                 inc   CRFlag                   ;set crFlag true.
4329 5C9A 6B                    rtl                            ;cr so exit and print the line.
4330 5C9B 64 C4        NotACR   stz   CRFlag                   ;set CRFlag to false.
4331 5C9D A5 BE        GALUntil lda   LineDone                 ;get line done.
4332 5C9F D0 06                 bne   GALExit                  ;if line done exit.
4333 5CA1 A5 C4                 lda   CRFlag                   ;get CRFlag.
4334 5CA3 D0 02                 bne   GALExit                  ;if CRFlag then exit.
4335 5CA5 80 C9                 bra   GALRepeat                ;Else continue repeating.
4336 5CA7 6B           GALExit  rtl                            ;exit.
4337 5CA8
4338 5CA8
4339 5CA8
4340 5CA8              ;---------------------------------------------------------------------
4341 5CA8              ;
4342 5CA8              ;OutputLine
4343 5CA8              ;1. DrawsText of length CharLine from TextPtr.
4344 5CA8              ;2. DrawsText in approptiate justification.
4345 5CA8              ;3. Positions cursor to left of newline.
4346 5CA8              ;
4347 5CA8              ;----------------------------------------------------------------------
4348 5CA8
4349 5CA8 A5 CE        OutputLine lda   TextJust               ;get justification.
4350 5CAA F0 55                 beq   Draw                     ;Check if Left if so draw.
4351 5CAC 30 43                 bmi   Right                    ;Check if Right justified.
4352 5CAE C9 02 00              cmp   #2                       ;Check if Center justified.
4353 5CB1 D0 2B                 bne   Center                   ;if so do center, else do fill.
4354 5CB3 A5 C4        Fill     lda   CrFlag                   ;(Matt says this will)
4355 5CB5 05 BC                 ora   InputDone                ;Don't fill last line.
4356 5CB7 D0 48                 bne   Draw                     ;(make everything perfect)
4357 5CB9 A5 98                 lda   CurrentSpaces            ;get number of spaces.
4358 5CBB D0 02                 bne   GetSpaceX                ;if not zero divide.
4359 5CBD E6 98                 inc   CurrentSpaces            ;else set spaces to 1.
4360 5CBF F4 00 00 F4  GetSpaceX PushLong #0 
4361 5CC5 A5 9C                 lda   MaxWidth                 ;get max width.
4362 5CC7 38                    sec   
4363 5CC8 E5 A0                 sbc   CurrentWidth             ;get the width used.
4364 5CCA 48                    pha                            ;push result of subtract.
4365 5CCB A5 98 48              PushWord CurrentSpaces         ;push denominator.
4366 5CCE A2 0B 0E 22           _FixRatio                      ;get fixed ratio.
4367 5CD5 A2 04 9E 22           _SetSpaceExtra                 ;set the extra space.
4368 5CDC 80 23                 bra   Draw                     ;now draw it.
4369 5CDE A5 9C        Center   lda   MaxWidth                 ;get max width.
4370 5CE0 38                    sec   
4371 5CE1 E5 A0                 sbc   CurrentWidth             ;get the width used.
4372 5CE3 4A                    lsr   A                        ;divide by 2.
4373 5CE4 48                    pha                            ;push hor pos.
4374 5CE5 F4 00 00              PushWord #0                    ;push zero change ver.
4375 5CE8 A2 04 3B 22           _Move                          ;move to appropriate spot.
4376 5CEF 80 10                 bra   Draw                     ;now draw it.
4377 5CF1 A5 9C        Right    lda   MaxWidth                 ;get MaxWidth.
4378 5CF3 38                    sec   
4379 5CF4 E5 A0                 sbc   CurrentWidth             ;get horizontal pos.
4380 5CF6 48                    pha                            ;push the hor pos.
4381 5CF7 F4 00 00              PushWord #0                    ;Push Vertical change.
4382 5CFA A2 04 3B 22           _Move                          ;Move to approriate spot.
4383 5D01 20 12 5D     Draw     jsr   DrawLine                 ;draw the line.
4384 5D04 F4 00 00 F4           PushLong #0                    ;setspace extra to zero...
4385 5D0A A2 04 9E 22           _SetSpaceExtra 
4386 5D11 6B                    rtl   
4387 5D12
4388 5D12              ;----------------------------------------------------------------------
4389 5D12              ;
4390 5D12              ;DrawLine
4391 5D12              ;
4392 5D12              ;----------------------------------------------------------------------
4393 5D12
4394 5D12 64 9A        DrawLine stz   TokenLength              ;Start Printing the line.
4395 5D14 A5 78                 lda   Change                   ;Change on this line?
4396 5D16 F0 3E                 beq   NoChange                 ;If not print the line.
4397 5D18 20 05 5E              jsr   SetRuler                 ;Set paramters to start of line.
4398 5D1B A5 9E        Loop     lda   CharLine                 ;Get length of string.
4399 5D1D C5 9A                 cmp   TokenLength
4400 5D1F F0 39                 beq   DrawRest                 ;If all of them are printed.
4401 5D21 30 37                 bmi   DrawRest                 ;if done draw remaining text.
4402 5D23 A5 9A                 lda   TokenLength              ;pass offset
4403 5D25 20 2B 60              jsr   LoadChar                 ;Get the next Char.
4404 5D28 C9 01 00              cmp   #DeltaFlg                ;Is Char a delta flag.
4405 5D2B D0 25                 bne   NextChar                 ;If not do next char.
4406 5D2D 20 35 5E              jsr   DrawPart                 ;draw part parsed so far.
4407 5D30 A5 9A        BumpingTP lda   TokenLength             ;Get Amount drawn.
4408 5D32 20 26 5C              jsr   BumpTextPtr              ;bump it.
4409 5D35 A5 9E                 lda   CharLine                 ;Get Length of string
4410 5D37 38                    sec   
4411 5D38 E5 9A                 sbc   TokenLength              ;subtract amount just drawn.
4412 5D3A 85 9E                 sta   CharLine                 ;save new length of line.
4413 5D3C A9 01 00              lda   #1
4414 5D3F 85 9A                 sta   TokenLength              ;reset TokenLength to one.
4415 5D41 20 2B 60              jsr   LoadChar                 ;get which change.
4416 5D44 E6 9A                 inc   TokenLength              ;get ready to load word
4417 5D46 A5 9A                 lda   TokenLength
4418 5D48 20 C7 60              jsr   GetDeltaWord             ;get the DeltaWord
4419 5D4B 85 A2                 sta   Temp
4420 5D4D 20 63 5D              jsr   DoDelta                  ;take care of delta
4421 5D50 80 C9                 bra   Loop
4422 5D52 E6 9A        NextChar inc   TokenLength
4423 5D54 80 C5                 bra   Loop
4424 5D56 A5 9E        NoChange lda   CharLine                 ;get length
4425 5D58 85 9A                 sta   TokenLength              ;get ready to print it.
4426 5D5A 20 35 5E     DrawRest jsr   DrawPart                 ;draw the rest of the loop.
4427 5D5D A5 9A                 lda   TokenLength
4428 5D5F 20 26 5C              jsr   BumpTextPtr
4429 5D62 60                    rts   
4430 5D63
4431 5D63              ;-------------------------------------------------------------------------
4432 5D63              ;
4433 5D63              ;DoDelta
4434 5D63              ;
4435 5D63              ;----------------------------------------------------------------------
4436 5D63
4437 5D63              DoDelta   
4438 5D63 A5 B8                 lda   Char
4439 5D65 C9 53 00              cmp   #S                       ;see if style change.
4440 5D68 D0 1B                 bne   TestF
4441 5D6A A5 A2 48              PushWord Temp                  ;push the word from GetWord.
4442 5D6D A2 04 9A 22           _SetTextFace                   ;Set the text Face.
4443 5D74 A0 06 00              ldy   #SizeStyle
4444 5D77 B7 B4                 lda   [LineRuler],y            ;get size/style
4445 5D79 29 00 FF              and   #$FF00                   ;mask off previous style
4446 5D7C 05 A2                 ora   Temp                     ;OR in new style
4447 5D7E 97 B4                 sta   [LineRuler],y            ;and save in ruler.
4448 5D80 20 35 60              jsr   UpDateHeight             ;Check if height has changed.
4449 5D83 80 6A                 bra   DoBpDelta
4450 5D85
4451 5D85 C9 46 00     TestF    cmp   #F                       ;see if font change.
4452 5D88 D0 27                 bne   TestC
4453 5D8A A9 01 00              lda   #1
4454 5D8D 85 DA                 sta   <GotFChange
4455 5D8F E6 9A                 inc   TokenLength              ;get next word.
4456 5D91 E6 9A                 inc   TokenLength
4457 5D93 A5 9A                 lda   TokenLength
4458 5D95 20 C7 60              jsr   GetDeltaWord             ;get new size/style
4459 5D98 A0 06 00              ldy   #SizeStyle
4460 5D9B 97 B4                 sta   [LineRuler],y            ;and save in ruler
4461 5D9D 20 B1 60              jsr   DoFont                   ;take care of the font.
4462 5DA0 A5 A2                 lda   Temp                     ;get new fam num
4463 5DA2 A0 04 00              ldy   #FamNum
4464 5DA5 97 B4                 sta   [LineRuler],y            ;and save in ruler.
4465 5DA7 20 35 60              jsr   UpDateHeight             ;See if maxHeight has changed.
4466 5DAA A9 06 00              lda   #6                       ;number to bump.
4467 5DAD 20 F6 5D              jsr   BumpDelta
4468 5DB0 60                    rts   
4469 5DB1
4470 5DB1 C9 43 00     TestC    cmp   #C                       ;check if fore color change.
4471 5DB4 D0 0C                 bne   TestB
4472 5DB6 A5 A2 48              PushWord Temp                  ;Push the index to color table.
4473 5DB9 A2 04 A0 22           _SetForeColor 
4474 5DC0 80 2D                 bra   DoBpDelta
4475 5DC2
4476 5DC2 C9 42 00     TestB    cmp   #B                       ;check if background color.
4477 5DC5 D0 0C                 bne   TestOther
4478 5DC7 A5 A2 48              PushWord Temp                  ;Push the index to color table.
4479 5DCA A2 04 A2 22           _SetBackColor 
4480 5DD1 80 1C                 bra   DoBpDelta
4481 5DD3
4482 5DD3 C9 4A 00     TestOther cmp   #J
4483 5DD6 F0 17                 beq   DoBpDelta                ;skip delta data.
4484 5DD8 C9 51 00              cmp   #Q
4485 5DDB F0 12                 beq   DoBpDelta
4486 5DDD C9 58 00              cmp   #X
4487 5DE0 F0 0D                 beq   DoBpDelta
4488 5DE2 C9 4C 00              cmp   #L
4489 5DE5 F0 08                 beq   DoBpDelta
4490 5DE7 C9 4D 00              cmp   #M
4491 5DEA F0 03                 beq   DoBpDelta
4492 5DEC 20 34 60              jsr   DoRuler
4493 5DEF A9 04 00     DoBpDelta lda   #4                      ;bump normal delta.
4494 5DF2 20 F6 5D              jsr   BumpDelta
4495 5DF5 60                    rts   
4496 5DF6
4497 5DF6
4498 5DF6              ;-------------------------------------------------------------------------
4499 5DF6              ;
4500 5DF6              ;BumpDelta
4501 5DF6              ;
4502 5DF6              ;----------------------------------------------------------------------
4503 5DF6
4504 5DF6 85 A2        BumpDelta sta   Temp
4505 5DF8 20 26 5C              jsr   BumpTextPtr
4506 5DFB A5 9E                 lda   CharLine                 ;GetNumber of Chars left.
4507 5DFD 38                    sec   
4508 5DFE E5 A2                 sbc   Temp                     ;subtract the delta string.
4509 5E00 85 9E                 sta   CharLine                 ;and save new value.
4510 5E02 64 9A                 stz   TokenLength
4511 5E04 60                    rts   
4512 5E05
4513 5E05
4514 5E05              ;--------------------------------------------------------------------------
4515 5E05              ;SetRuler
4516 5E05              ;
4517 5E05              ;Takes the ChangeFlg and sets each paramater that is marked for change.
4518 5E05              ;
4519 5E05              ;----------------------------------------------------------------------
4520 5E05 A5 7C        SetRuler lda   ChangeFlg
4521 5E07 F0 2B                 beq   AllSet                   ;no changes, so quit.
4522 5E09 46 7C                 lsr   ChangeFlg                ;get Style bit
4523 5E0B 90 14                 bcc   CheckFont
4524 5E0D              ;set style
4525 5E0D A0 06 00              ldy   #SizeStyle
4526 5E10 B7 B4                 lda   [LineRuler],y            ;get size/style
4527 5E12 29 FF 00              and   #$00FF                   ;mask off size
4528 5E15 48                    pha   
4529 5E16 A2 04 9A 22           _SetTextFace 
4530 5E1D A5 7C                 lda   ChangeFlg
4531 5E1F F0 13                 beq   AllSet
4532 5E21
4533 5E21 46 7C        CheckFont lsr   ChangeFlg               ;get Font bit.
4534 5E23 90 0F                 bcc   AllSet
4535 5E25 A0 04 00              ldy   #FamNum
4536 5E28 B7 B4                 lda   [LineRuler],y
4537 5E2A 85 A2                 sta   Temp                     ;save in Temp for DoFont call.
4538 5E2C A0 06 00              ldy   #SizeStyle
4539 5E2F B7 B4                 lda   [LineRuler],y
4540 5E31 20 B1 60              jsr   DoFont
4541 5E34
4542 5E34 60           AllSet   rts   
4543 5E35
4544 5E35              ;allow R (ruler) change someday
4545 5E35
4546 5E35
4547 5E35              ;----------------------------------------------------------------------
4548 5E35              ;
4549 5E35              ;DrawPart
4550 5E35              ;1. Draws Text of length CharLine from TextPtr.
4551 5E35              ;2. Positions Cursor to left on new line.
4552 5E35              ;3. resets currentHeight.
4553 5E35              ;
4554 5E35              ;----------------------------------------------------------------------
4555 5E35              DrawPart  
4556 5E35 A0 12 00              ldy   #EQTemperedLS
4557 5E38 B7 B4                 lda   [LineRuler],y
4558 5E3A D0 10                 bne   Drawn
4559 5E3C A5 D8 48 A5           PushLong TextPtr 
4560 5E42 A5 9A 48              PushWord TokenLength 
4561 5E45 A2 04 A7 22           _DrawText 
4562 5E4C 60           Drawn    rts   
4563 5E4D
4564 5E4D              ;----------------------------------------------------------------------
4565 5E4D              ;
4566 5E4D              ;NewLine
4567 5E4D              ;
4568 5E4D              ;----------------------------------------------------------------------
4569 5E4D A0 02 00     NewLine  ldy   #2                       ;get offset to left.
4570 5E50 B7 D0                 lda   [TextRectPtr],y          ;get left.
4571 5E52 A0 0C 00              ldy   #LeftMargin
4572 5E55 18                    clc   
4573 5E56 77 B4                 adc   [LineRuler],y
4574 5E58 48                    pha                            ;push horizontal.
4575 5E59 A5 6C                 lda   MaxLine
4576 5E5B F0 05                 beq   addMHeight
4577 5E5D 18                    clc   
4578 5E5E 65 C2                 adc   CurrentHeight
4579 5E60 80 05                 bra   addFont
4580 5E62 A5 C2        AddMHeight lda   CurrentHeight          ;get current height
4581 5E64 18                    clc   
4582 5E65 65 C0                 adc   MaxHeight                ;add MaxHeight change.
4583 5E67 A0 06 00     AddFont  ldy   #6
4584 5E6A 38                    sec   
4585 5E6B F7 86                 sbc   [FontInfoPtr],y
4586 5E6D 18                    clc   
4587 5E6E 65 6A                 adc   LastLeading
4588 5E70 A0 10 00              ldy   #ExtraSpacing
4589 5E73 18                    clc   
4590 5E74 77 B4                 adc   [LineRuler],y
4591 5E76 85 C2                 sta   CurrentHeight            ;save result as new cur height.
4592 5E78 48                    pha                            ;push vert. position.
4593 5E79 A2 04 3A 22           _MoveTo                        ;move to new line.
4594 5E80 60                    rts   
4595 5E81
4596 5E81              ;---------------------------------------------------------------
4597 5E81              ;
4598 5E81              ;ScanBlanks
4599 5E81              ;
4600 5E81              ;----------------------------------------------------------------------
4601 5E81
4602 5E81 20 C7 5E     ScanBlanks jsr   GetNextChar            ;get the next char in char.
4603 5E84 A5 BC                 lda   InputDone                ;get input done.
4604 5E86 D0 18                 bne   ExitSB                   ;if set exit ScanBlanks
4605 5E88 A5 B8                 lda   Char                     ;get the char.
4606 5E8A C9 20 00              cmp   #$20                     ;compare with space.
4607 5E8D D0 06                 bne   CkTbChar                 ;if not a space Check if tab.
4608 5E8F E6 96                 inc   Spaces                   ;increment number of spaces.
4609 5E91 E6 9A                 inc   TokenLength              ;and number of tokens.
4610 5E93 80 EC                 bra   ScanBlanks               ;keep scaning until exit.
4611 5E95 C9 09 00     CkTbChar cmp   #$09                     ;check if char is a tab.
4612 5E98 D0 06                 bne   ExitSB                   ;exit ScanBlanks if not a tab.
4613 5E9A E6 A4                 inc   Tabs                     ;else increment # of tabs.
4614 5E9C E6 9A                 inc   TokenLength              ;and number of tokens.
4615 5E9E 80 E1                 bra   ScanBlanks               ;keep scaning until exit.
4616 5EA0 60           ExitSB   rts                            ;Done scanning blanks.
4617 5EA1
4618 5EA1
4619 5EA1              ;---------------------------------------------------------------
4620 5EA1              ;
4621 5EA1              ;ScanToken
4622 5EA1              ;
4623 5EA1 20 C7 5E     ScanToken jsr   GetNextChar             ;get the next char.
4624 5EA4 A5 BC                 lda   InputDone                ;get input done.
4625 5EA6 D0 1E                 bne   STExit                   ;if set exit scan token.
4626 5EA8 A5 B8                 lda   Char                     ;else get the char.
4627 5EAA C9 20 00              cmp   #$20                     ;check if space.
4628 5EAD F0 17                 beq   STExit                   ;if a space than exit.
4629 5EAF 10 0F                 bpl   Token                    ;if gt it's still a token.
4630 5EB1 C9 09 00              cmp   #$09                     ;check if tab
4631 5EB4 F0 10                 beq   STExit                   ;if so then exit.
4632 5EB6 C9 0D 00              cmp   #$0D                     ;check if CR
4633 5EB9 F0 09                 beq   ItsACR                   ;if so then count it and exit.
4634 5EBB C9 01 00              cmp   #DeltaFlg
4635 5EBE F0 04                 beq   ItsACR                   ;if delta flag exit.
4636 5EC0 E6 9A        Token    inc   TokenLength              ;it's a token so inc toklen.
4637 5EC2 80 DD                 bra   ScanToken                ;keep going until exit.
4638 5EC4 E6 BE        ItsACr   inc   LineDone                 ;set line done, to exit on cr.
4639 5EC6 60           STExit   rts   
4640 5EC7
4641 5EC7              ;------------------------------------------------------------------
4642 5EC7              ;
4643 5EC7              ;GetNextChar
4644 5EC7
4645 5EC7 20 1A 60     GetNextChar jsr   GrabChar              ;Get the nextchar
4646 5ECA A5 BC                 lda   InputDone
4647 5ECC D0 50                 bne   GNCExit
4648 5ECE A5 B8                 lda   char
4649 5ED0 C9 01 00              cmp   #DeltaFlg                ;Is char deltaflg marker?
4650 5ED3 D0 49                 bne   GNCExit                  ;If not exit
4651 5ED5 E6 78                 inc   Change                   ;A delta exists on this line.
4652 5ED7 20 CB 60              jsr   CheckDone                ;Check if current stuff fits.
4653 5EDA A5 BE                 lda   LineDone                 ;Get line done.
4654 5EDC D0 40                 bne   GNCExit                  ;if done then exit
4655 5EDE E6 9A                 inc   TokenLength              ;pass DeltaFlg
4656 5EE0 20 D4 5B              jsr   GetOffset                ;add TokenLength and CharLine.
4657 5EE3 20 2B 60              jsr   LoadChar                 ;What kind of delta is it?
4658 5EE6 E6 9A                 inc   TokenLength              ;account for marker.
4659 5EE8 20 D4 5B              jsr   GetOffset                ;Add TokenLength and CharLine.
4660 5EEB 20 C7 60              jsr   GetDeltaWord
4661 5EEE 85 A2                 sta   Temp                     ;store delta word in temp.
4662 5EF0
4663 5EF0 A5 B8                 lda   Char
4664 5EF2 C9 53 00              cmp   #S
4665 5EF5 D0 28                 bne   ChkFont
4666 5EF7 A5 A2 48              PushWord Temp                  ;Push the delta word.
4667 5EFA A2 04 9A 22           _SetTextFace                   ;set the textface.
4668 5F01 A5 7A                 lda   Skiping
4669 5F03 F0 0F                 beq   NoSkip1
4670 5F05 A0 06 00              ldy   #SizeStyle
4671 5F08 B7 B4                 lda   [LineRuler],y            ;get size/style
4672 5F0A 29 00 FF              and   #$FF00                   ;mask off previous style
4673 5F0D 05 A2                 ora   Temp                     ;OR in new style
4674 5F0F 97 B4                 sta   [LineRuler],y            ;and save in ruler.
4675 5F11 82 B6 00              brl   DeltaEnd
4676 5F14
4677 5F14 A5 7C        NoSkip1  lda   ChangeFlg                ;get ChangeFlg.
4678 5F16 09 01 00              ora   #$0001                   ;set style flg.
4679 5F19 85 7C                 sta   ChangeFlg                ;save the change.
4680 5F1B 82 AC 00              brl   DeltaEnd
4681 5F1E
4682 5F1E 60           GNCExit  rts   
4683 5F1F
4684 5F1F C9 46 00     ChkFont  cmp   #F                       ;See if Font Change.
4685 5F22 D0 2D                 bne   ChkColorChng             ;if not check if a color change.
4686 5F24 E6 9A                 inc   TokenLength
4687 5F26 E6 9A                 inc   TokenLength
4688 5F28 20 D4 5B              jsr   GetOffset
4689 5F2B 20 C7 60              jsr   GetDeltaWord             ;get size/style
4690 5F2E A6 7A                 ldx   Skiping
4691 5F30 F0 05                 beq   NoSkip2
4692 5F32 A0 06 00              ldy   #SizeStyle
4693 5F35 97 B4                 sta   [LineRuler],y            ;save new size/style in ruler
4694 5F37              NoSkip2                                 ;
4695 5F37 20 B1 60              jsr   DoFont                   ;Take care of the font change.
4696 5F3A A5 7A                 lda   Skiping
4697 5F3C F0 0A                 beq   NoSkip3
4698 5F3E A5 A2                 lda   Temp
4699 5F40 A0 04 00              ldy   #FamNum
4700 5F43 97 B4                 sta   [LineRuler],y
4701 5F45 82 82 00              brl   DeltaEnd
4702 5F48
4703 5F48 A5 7C        NoSkip3  lda   ChangeFlg                ;get ChangeFlg.
4704 5F4A 09 02 00              ora   #$0002                   ;set Font flg.
4705 5F4D 85 7C                 sta   ChangeFlg                ;save the change.
4706 5F4F 80 79                 bra   DeltaEnd
4707 5F51
4708 5F51
4709 5F51 C9 43 00     ChkColorChng cmp   #C
4710 5F54 D0 10                 bne   ChkQ
4711 5F56 A5 7A                 lda   Skiping                  ;bug fix 5-6-87 CAE
4712 5F58 F0 70                 beq   DeltaEnd
4713 5F5A A5 A2 48              PushWord Temp 
4714 5F5D A2 04 A0 22           _SetForeColor                  ;end bug fix
4715 5F64 80 64                 bra   DeltaEnd
4716 5F66
4717 5F66              ChkQ      
4718 5F66 C9 51 00              cmp   #Q
4719 5F69 D0 05                 bne   ChkBGround
4720 5F6B 20 D0 5F              jsr   H5FD0
4721 5F6E 80 5A                 bra   DeltaEnd
4722 5F70
4723 5F70 C9 42 00     ChkBGround cmp   #B
4724 5F73 D0 10                 bne   ChkExtra
4725 5F75 A5 7A                 lda   Skiping                  ;bug fix 5-6-87 CAE
4726 5F77 F0 51                 beq   DeltaEnd
4727 5F79 A5 A2 48              PushWord Temp 
4728 5F7C A2 04 A2 22           _SetBackColor                  ;end bug fix
4729 5F83 80 45                 bra   DeltaEnd
4730 5F85
4731 5F85 C9 58 00     ChkExtra cmp   #X
4732 5F88 D0 09                 bne   CheckLMargin
4733 5F8A A0 10 00              ldy   #ExtraSpacing
4734 5F8D A5 A2                 lda   Temp
4735 5F8F 97 B4                 sta   [LineRuler],y
4736 5F91 80 37                 bra   DeltaEnd
4737 5F93
4738 5F93 C9 4C 00     CheckLMargin cmp   #L
4739 5F96 D0 0C                 bne   CheckRMargin
4740 5F98 A0 0C 00              ldy   #LeftMargin
4741 5F9B A5 A2                 lda   Temp
4742 5F9D 97 B4                 sta   [LineRuler],y
4743 5F9F 20 0C 5C              jsr   GetMaxWidth
4744 5FA2 80 26                 bra   DeltaEnd
4745 5FA4
4746 5FA4 C9 4D 00     CheckRMargin cmp   #M
4747 5FA7 D0 0C                 bne   CheckJust
4748 5FA9 A0 0E 00              ldy   #RightMargin
4749 5FAC A5 A2                 lda   Temp
4750 5FAE 97 B4                 sta   [LineRuler],y
4751 5FB0 20 0C 5C              jsr   GetMaxWidth
4752 5FB3 80 15                 bra   DeltaEnd
4753 5FB5
4754 5FB5 C9 4A 00     CheckJust cmp   #J
4755 5FB8 D0 06                 bne   CheckRuler
4756 5FBA A5 A2                 lda   Temp
4757 5FBC 85 CE                 sta   TextJust
4758 5FBE 80 0A                 bra   DeltaEnd
4759 5FC0
4760 5FC0 C9 52 00     CheckRuler cmp   #R
4761 5FC3 D0 05                 bne   DeltaEnd
4762 5FC5 20 34 60              jsr   DoRuler                  ;mark new ruler
4763 5FC8 80 00                 bra   DeltaEnd
4764 5FCA
4765 5FCA 20 0E 60     DeltaEnd jsr   CountDelta
4766 5FCD 82 F7 FE              brl   GetNextChar              ;continue
4767 5FD0
4768 5FD0 A5 A2        H5FD0    lda   Temp
4769 5FD2 F0 1F                 beq   H5FF3
4770 5FD4 A0 12 00              ldy   #SaveClip+2
4771 5FD7 B7 B4                 lda   [LineRuler],y
4772 5FD9 F0 07                 beq   H5FE2
4773 5FDB A9 00 00              lda   #0
4774 5FDE 97 B4                 sta   [LineRuler],y
4775 5FE0 80 2B                 bra   H600D
4776 5FE2 A9 01 00     H5FE2    lda   #1
4777 5FE5 97 B4                 sta   [LineRuler],y
4778 5FE7 64 6C                 stz   MaxLine
4779 5FE9 A5 D6                 lda   TextPtr
4780 5FEB 85 72                 sta   TempTP
4781 5FED A5 D4                 lda   TextLen
4782 5FEF 85 76                 sta   TempTL
4783 5FF1 80 1A                 bra   H600D
4784 5FF3 A0 12 00     H5FF3    ldy   #SaveClip+2
4785 5FF6 B7 B4                 lda   [LineRuler],y
4786 5FF8 D0 04                 bne   H5FFE
4787 5FFA 64 6C                 stz   Maxline
4788 5FFC 80 0F                 bra   H600D
4789 5FFE A9 00 00     H5FFE    lda   #0
4790 6001 97 B4                 sta   [LineRuler],y
4791 6003 E6 BC                 inc   InputDone
4792 6005 A5 72                 lda   TempTP
4793 6007 85 D6                 sta   TextPtr
4794 6009 A5 76                 lda   TempTL
4795 600B 85 D4                 sta   TextLen
4796 600D 60           H600D    rts   
4797 600E
4798 600E
4799 600E              ;-----------------------------------------------------------------------------
4800 600E              ;
4801 600E E6 9A        CountDelta inc   TokenLength
4802 6010 E6 9A                 inc   TokenLength
4803 6012 20 D4 5B              jsr   GetOffset                ;add TokenLength and charLine.
4804 6015 85 9E                 sta   CharLine                 ;store in CharLine
4805 6017 64 9A                 stz   TokenLength
4806 6019 60                    rts   
4807 601A
4808 601A
4809 601A              ;----------------------------------------------------------------------------
4810 601A              ;
4811 601A 20 D4 5B     GrabChar jsr   GetOffset                ;Add CharLine and TokenLength
4812 601D 85 BA                 sta   OffSet                   ;to get total OffSet.
4813 601F C5 D4                 cmp   TextLen                  ;compare it to OffSet.
4814 6021 10 05                 bpl   getout
4815 6023 20 2B 60     StillInputLeft jsr   LoadChar           ;get the char.
4816 6026 80 02                 bra   GCExit
4817 6028 E6 BC        getout   inc   Inputdone                ;and put in input done.
4818 602A 60           GCExit   rts   
4819 602B
4820 602B              ;------------------------------------------------------------------
4821 602B              ;
4822 602B              ;LoadChar
4823 602B              ;
4824 602B              ;Puts next char in char variable, from TextPtr with an offset in the accum.
4825 602B              ;
4826 602B A8           LoadChar tay                            ;put OffSet in y.
4827 602C B7 D6                 lda   [TextPtr],y              ;get charachters.
4828 602E 29 FF 00              and   #$00FF                   ;get only one Char.
4829 6031 85 B8                 sta   char                     ;store in Char.
4830 6033 60                    rts   
4831 6034
4832 6034              ;----------------------------------------------------------------
4833 6034              ;
4834 6034              ;DoRuler
4835 6034              ;
4836 6034              DoRuler                                 ;needs to handle the rulers
4837 6034 60                    rts                            ;for future R change
4838 6035
4839 6035              ;-----------------------------------------------------------------------
4840 6035              ;
4841 6035              ;UpDateHeight
4842 6035              ;
4843 6035 20 4E 60     UpDateHeight jsr   GetHeight
4844 6038 C5 C0                 cmp   MaxHeight
4845 603A 90 11                 bcc   smaller
4846 603C 85 C0                 sta   MaxHeight                ;It's bigger so save it.
4847 603E
4848 603E A0 12 00              ldy   #SaveClip+2
4849 6041 B7 B4                 lda   [LineRuler],y
4850 6043 F0 08                 beq   smaller
4851 6045 A5 C0                 lda   MaxHeight
4852 6047 C5 6C                 cmp   MaxLine
4853 6049 90 02                 bcc   smaller
4854 604B 85 6C                 sta   Maxline
4855 604D
4856 604D 60           smaller  rts   
4857 604E
4858 604E
4859 604E              ;----------------------------------------------------------------------
4860 604E              ;
4861 604E              ;GetHeight
4862 604E              ;
4863 604E 7B           GetHeight tdc                           ;transfer direct page to accumulator.
4864 604F 18                    clc   
4865 6050 69 8A 00              adc   #FontInfoRec             ;add offset to record.
4866 6053 64 88                 stz   FontInfoPtr+2            ;It's on directPage.
4867 6055 85 86                 sta   FontInfoPtr              ;Store address.
4868 6057 A5 88                 lda   FontInfoPtr+2            ;pass pointer
4869 6059 48                    pha   
4870 605A A5 86                 lda   FontInfoPtr
4871 605C 48                    pha   
4872 605D A2 04 96 22           _GetFontInfo                   ;get the font info
4873 6064 A7 86                 lda   [FontInfoPtr]            ;get ascent
4874 6066 A0 06 00              ldy   #6
4875 6069 18                    clc   
4876 606A 77 86                 adc   [FontInfoPtr],y          ;add leading.
4877 606C A0 02 00              ldy   #2
4878 606F 18                    clc   
4879 6070 77 86                 adc   [FontInfoPtr],y          ;add descent.
4880 6072 60                    rts   
4881 6073
4882 6073              ;--------------------------------------------------------------------
4883 6073              ;
4884 6073              ;ResetPort
4885 6073              ;
4886 6073              ;Resets the Port back to the way it was when textbox was called.
4887 6073              ;
4888 6073              ResetPort                               ;
4889 6073 A0 1C 00              ldy   #SizeStyle+NextRuler
4890 6076 B7 B4                 lda   [LineRuler],y            ;get size/style
4891 6078 29 FF 00              and   #$00FF                   ;mask off size
4892 607B 48                    pha   
4893 607C A2 04 9A 22           _SetTextFace                   ;set style
4894 6083
4895 6083 A5 DA                 lda   <GotFChange
4896 6085 F0 0F                 beq   NoFontChange
4897 6087 A0 1A 00              ldy   #FamNum+NextRuler
4898 608A B7 B4                 lda   [LineRuler],y
4899 608C 85 A2                 sta   Temp
4900 608E A0 1C 00              ldy   #SizeStyle+NextRuler
4901 6091 B7 B4                 lda   [LineRuler],y
4902 6093 20 B1 60              jsr   DoFont
4903 6096              NoFontChange  
4904 6096
4905 6096 A0 16 00              ldy   #FGroundColor+NextRuler
4906 6099 B7 B4                 lda   [LineRuler],y
4907 609B 48                    pha   
4908 609C A2 04 A0 22           _SetForeColor                  ;set foreground color
4909 60A3 A0 18 00              ldy   #BGroundColor+NextRuler
4910 60A6 B7 B4                 lda   [LineRuler],y
4911 60A8 48                    pha   
4912 60A9 A2 04 A2 22           _SetBackColor                  ;set Background color
4913 60B0
4914 60B0 60                    rts   
4915 60B1
4916 60B1              ;----------------------------------------------------------------------
4917 60B1              ;
4918 60B1              ;DoFont
4919 60B1              ;
4920 60B1              DoFont    
4921 60B1 48                    pha                            ;Push the size and style.
4922 60B2 A5 A2 48              PushWord Temp                  ;push the fam num
4923 60B5 F4 00 00              PushWord #0                    ;scaling.
4924 60B8 A2 1B 0E 22           _InstallFont                   ;Change the font.
4925 60BF 90 01                 bcc   FontInstalled            ;font installed, no error.
4926 60C1 60                    rts                            ;exit there was an error.
4927 60C2
4928 60C2              FontInstalled                           ;
4929 60C2 20 35 60              jsr   UpdateHeight             ;reset Height dependencies.
4930 60C5 18                    clc                            ;clear carry if no error.
4931 60C6 60                    rts   
4932 60C7
4933 60C7              ;--------------------------------------------------------------
4934 60C7              ;
4935 60C7              ;GetDeltaWord
4936 60C7              ;
4937 60C7              ;Returns the word, at TextPtr with offset in the accum., in the accum.
4938 60C7              ;
4939 60C7 A8           GetDeltaWord tay                        ;put it y for offset
4940 60C8 B7 D6                 lda   [TextPtr],y              ;get the word
4941 60CA 60                    rts   
4942 60CB
4943 60CB
4944 60CB              ;--------------------------------------------------------------
4945 60CB              ;
4946 60CB              ;CheckDone
4947 60CB
4948 60CB              CheckDone  
4949 60CB F4 00 00              Pushword #0                    ;Push Space for result.
4950 60CE A5 D6                 lda   TextPtr                  ;get low word of TextPtr.
4951 60D0 18                    clc   
4952 60D1 65 9E                 adc   CharLine                 ;add offset to it.
4953 60D3 85 A2                 sta   Temp                     ;save low word.
4954 60D5 A5 D8                 lda   TextPtr+2                ;get high word.
4955 60D7 69 00 00              adc   #0                       ;add carry to highword.
4956 60DA 48                    pha                            ;push high word.
4957 60DB A5 A2 48              PushWord Temp                  ;push low word.
4958 60DE A5 9A 48              PushWord TokenLength           ;push length of text
4959 60E1 A2 04 AB 22           _TextWidth                     ;get the textwidth.
4960 60E8 68                    pla                            ;get the width.
4961 60E9 18                    clc   
4962 60EA 65 A0                 adc   CurrentWidth             ;add to CurrentWidth.
4963 60EC C5 9C                 cmp   MaxWidth                 ;are we past the limit?
4964 60EE F0 07                 beq   MoreToDo
4965 60F0 30 05                 bmi   MoreToDo                 ;if so, we're done
4966 60F2 64 BC                 stz   inputDone
4967 60F4 E6 BE        SetLineDone inc   LineDone              ;and store it in line done.
4968 60F6 60                    rts   
4969 60F7
4970 60F7 85 A0        MoreToDo sta   CurrentWidth
4971 60F9 20 D4 5B              jsr   GetOffset                ;add charline and TokenLength.
4972 60FC 85 9E                 sta   CharLine                 ;save CharLine
4973 60FE A5 96                 lda   Spaces                   ;Get # of spaces.
4974 6100 18                    clc   
4975 6101 65 98                 adc   CurrentSpaces            ;add to currentspaces.
4976 6103 85 98                 sta   CurrentSpaces            ;save current spaces.
4977 6105 64 96                 stz   Spaces                   ;clear spaces.
4978 6107 64 9A                 stz   TokenLength              ;clear TokenLength.
4979 6109 64 A6                 stz   Nothing                  ;set nothing to false.
4980 610B 60           CDExit   rts                            ;done.
4981 610C
4982 610C
4983 610C
4984 610C              ;------------------------------------------------------------
4985 610C              ;
4986 610C              ;BrkToken
4987 610C
4988 610C C6 9A        BrkToken dec   TokenLength              ;TokenLength =- 1
4989 610E 20 CB 60              jsr   CheckDone                ;check if done.
4990 6111 A5 9A                 lda   TokenLength              ;get tokenLength.
4991 6113 D0 08                 bne   BTUntil                  ;check until condition.
4992 6115 A5 9E                 lda   CharLine                 ;get charline
4993 6117 D0 04                 bne   BTUntil                  ;if nothing will fit quit!
4994 6119 64 BE                 stz   LineDone                 ;finished so set exit.
4995 611B E6 BC                 inc   InputDone                ;inputdone = 1
4996 611D A5 9A        BTUntil  lda   TokenLength              ;get lineDone.
4997 611F D0 EB                 bne   BrkToken                 ;if not zero keep backing up.
4998 6121 E6 BE                 inc   LineDone                 ;Linedone = 1.
4999 6123 60                    rts   
5000 6124
5001 6124                       EndP 
5002 6124                       print POP 
5003 6124
5004 6124
5005 6124                       END   
